/**************************************************************************
                    fmplayer.cpp  -  all the FMPlayer-API
                            -------------------
    begin                : September 20th 2002
    copyright            : (C) 2002-2003 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "include/fmplayer.h"
#include "fmplayer_player.cpp"
#include "fmplayer_channel.cpp"
#include "fmplayer_package.cpp"
#include "fmplayer_file.cpp"
#include "fmplayer_soundfile.cpp"
#include "fmplayer_hffile.cpp"
#include "fmplayer_midi.cpp"

using namespace std;

void writeSoundByte(char * byte, bool wav, int bytes, int dspfd) {
	if(wav){
		writeWavByte(byte, bytes);
	}
#ifdef DSP_WORKS
	else
	  write(dspfd, byte, bytes);
#endif
}

float   ggt(float a, float b) {

	if(a < 0)
		a = a * -1;

	if(b < 0)
		b = b * -1;

	if(b>a)
		return ggt(b, a);

	if(b!=0)
		return ggt(b, fmod(a, b));

	else
		return a;
}

float   kgv(float a, float b) {

	return a*b/ggt(a, b);

}
