/**************************************************************************
                    fmplayer.cpp  -  all the FMPlayer-API
                            -------------------
    begin                : September 20th 2002
    copyright            : (C) 2002-2003 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "include/fmplayer.h"

using namespace std;

/*----------------------------------------------------------------*/


FMChannel::FMChannel(FMPlayer *parentPlayer) {
	if(debug_level>1)
		cout << "FMChannel::FMChannel called" << endl;
	player  = parentPlayer;
	first   = new FMPackage(this);
	package = first;
	syncPointer();
	repeat  = 1;
	ptr     = 0;
	do_play = 1;
	dr      = 0;
}

FMChannel::~FMChannel(){
	if(debug_level>1)
		cout << "FMChannel::~FMChannel called" << endl;
	delete first;
	if(debug_level>1)
		cout << "FMChannel::~FMChannel finished" << endl;
}

bool  FMChannel::play(){
	return do_play;
}

void  FMChannel::setPlay(bool r){
	if(debug_level>1)
		cout << "FMChannel::setPlay called" << endl;
	FMPackage * tmp = first;
	while(tmp){
		tmp->compLockAll();
		tmp = tmp->next;
	}
	FMChannel * other;
	if(this==player->first)
		other = player->second;
	else
		other = player->first;
	tmp = other->first;
	while(tmp){
		tmp->compLockAll();
		tmp = tmp->next;
	}
	do_play = r;
}

void  FMChannel::nextPackage(bool create) {
	if(debug_level>1)
		cout << "FMChannel::nextPackage called" << endl;
	if(!create && package->next){
		package = package->next;
		syncPointer();
		if(debug_level>1)
			cout << "FMChannel::nextPackage finished without create" << endl;
		return;
	}
	package = first;
	while(package->next)
		package = package->next;
	package->next = new FMPackage(this);
	package = package->next;
	syncPointer();
	if(debug_level>1)
		cout << "FMChannel::nextPackage finished with create" << endl;
}

void  FMChannel::firstPackage() {
	if(debug_level>1)
		cout << "FMChannel::firstPackage called" << endl;
	package = first;
	syncPointer();
}

void  FMChannel::nextSound() {
	if(debug_level>1)
		cout << "FMChannel::nextSound called" << endl;
	package->nextSound();
	syncPointer();
}

void  FMChannel::firstSound() {
	if(debug_level>1)
		cout << "FMChannel::firstSound called" << endl;
	package->firstSound();
	syncPointer();
}

void  FMChannel::setRepeat(int drepeat){
	if(debug_level>1)
		cout << "FMChannel::setRepeat called" << endl;
	repeat = drepeat;
}

int FMChannel::getRepeat() const {
	if(debug_level>1)
		cout << "FMChannel::getRepeat called" << endl;
	return repeat;
}

void  FMChannel::openFiles() {
	if(debug_level>1)
		cout << "FMChannel::openFiles called" << endl;
 try{
	FMPackage * tmppackage = first;
	while(tmppackage){
		tmppackage->openFiles();
		tmppackage = tmppackage->next;
	}
 }
 catch(...){
 	cout <<  "catch error in FMChannel::openFiles" << endl;
	throw;
 }
}

void  FMChannel::compute() {
	if(debug_level>1)
		cout << "FMChannel::compute called" << endl;
	package = first;
	while(package){
		package->compute();
		package = package->next;
	}
	ptr = first->values;
	package = first;
	dr = 0;
}

void  FMChannel::syncPointer() {
	if(debug_level>1)
		cout << "FMChannel::syncPointer called" << endl;
 if(package)
	sound = package->sound;
	if(debug_level>1)
		cout << "FMChannel::syncPointer finished" << endl;
}

void  FMChannel::ptrInc() {
  if(ptr){
	ptr++;
	i++;
	if(ptr >= package->values + package->getRval()){
		ptr = package->values;
	}
	if(i   >= package->getTime() * player->getRate() * package->getRepeat()){
		// channel repeat problematisch!
		package = package->next;
		i = 0;
		if(package){
			ptr = package->values;
		}
		else{
			dr++;
			if((dr>=repeat && player->getPlayMode() != DSP) || dr==repeat)
				ptr = 0;
			else{
				ptr = first->values;
				package = first;
				i = 0;
			}
		}
	}
  }
}

void  FMChannel::pointerReset() {
	if(debug_level>1)
		cout << "FMChannel::pointerReset called" << endl;
	package = first;
	ptr = package->values;
	i = 0;
	if(debug_level>1)
		cout << "FMChannel::pointerReset finished" << endl;
}

