/**************************************************************************
                    fmplayer.cpp  -  all the FMPlayer-API
                            -------------------
    begin                : September 20th 2002
    copyright            : (C) 2002-2003 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "include/fmplayer.h"

using namespace std;

/*----------------------------------------------------------------*/

int FMFile::lfd_nr = 1;

void FMFile::fakeOpen()
{ open_lock=1; }


FMFile::FMFile(FMPackage *parentPackage){
	if(debug_level>1)
		cout << "FMFile::FMFile called" << endl;
	package  = parentPackage;
        filename = new char[strlen(DATADIR "/sounds/sin")];
	strcpy(filename,DATADIR "/sounds/sin");
	freq     = 1;
	hvol    = 0;
	ffreq   = 0;
	mlm     = 0;
	rnf     = 0;
	atime    = 0.0;
	open_lock = 0;
	anti     = 0;
	volume   = 1.0;
	m    = Sound;
	mlen = 10.0;
	till = 0;
	nval = 0.0;
	nr = lfd_nr;
	lfd_nr++;
	if(debug_level>1)
		cout << "FMFile::FMFile finished, FMFile No." << nr << " has been created" << endl;
}

FMFile::~FMFile(){
	if(debug_level>1)
		cout << "FMFile::~FMFile called" << endl;
	cleanup();
	if(filename)
		delete []filename;
	filename = 0;
	if(hvol)
		delete hvol;
	if(ffreq)
		delete ffreq;
	if(mlm)
		delete mlm;
	if(rnf)
		delete rnf;
	if(debug_level>1)
		cout << "FMFile::~FMFile finished" << endl;
}

bool FMFile::openLock(){
	if(debug_level>1)
		cout << "FMFile::openLock called (" << open_lock << ")" << endl;
	if(ffreq && !ffreq->openLock())
		return 0;
	if(hvol && !hvol->openLock())
		return 0;
	if(mlm && !mlm->openLock())
		return 0;
	if(rnf && !rnf->openLock())
		return 0;
	return open_lock;
}

bool FMFile::compLock(){
	if(debug_level>1)
		cout << "FMFile::compLock called" << endl;
	if(ffreq && !ffreq->compLock())
		return 0;
	if(hvol && !hvol->compLock())
		return 0;
	if(mlm && !mlm->compLock())
		return 0;
	if(rnf && !rnf->compLock())
		return 0;
	return 1;
}

void FMFile::compute(){
	if(debug_level>1)
		cout << "FMFile::compute called" << endl;
	if(hvol)
		hvol->compute();
	if(ffreq)
		ffreq->compute();
	if(mlm)
		mlm->compute();
	if(rnf)
		rnf->compute();
}

char * FMFile::getFilename() const {
	if(debug_level>1)
		cout << "FMFile::getFilename called: " << filename << endl;
	return filename;
}

void   FMFile::setFilename(char * dfilename) {
	if(debug_level>1)
		cout << "FMFile::setFilename called, filename=" << dfilename << endl;
	if(filename)
		delete []filename;
	filename = new char[strlen(dfilename)+1];
	strcpy(filename,dfilename);
	filename[strlen(dfilename)] = '\0';
	open_lock = 0;
	if(debug_level>1)
		cout << "FMFile::setFilename finished, filename=" << filename << endl;
}

void   FMFile::setFilename(const char * dfilename) {
	if(debug_level>1)
		cout << "FMFile::setFilename called, filename=" << dfilename << endl;
	if(filename)
		delete []filename;
	filename = new char[strlen(dfilename)+1];
	strcpy(filename,dfilename);
	filename[strlen(dfilename)] = '\0';
	open_lock = 0;
	if(debug_level>1)
		cout << "FMFile::setFilename finished, filename=" << filename << endl;
}


float  FMFile::getFreq() const {
	if(debug_level>1)
		cout << "FMFile::getFreq called" << endl;
	return freq;
}

void   FMFile::setFreq(float dfreq) {
	freq = dfreq;
	if(!ffreq)
		package->compLockAll();
	// uh, oh, that might not work
	// should we set ffreq->max, too?
}

void  FMFile::setVolume(float dvolume, bool setptvol){
	if(debug_level>1)
		cout << "FMFile::setVolume called" << endl;
	if(setptvol){
		if(debug_level>1)
			cout << "changing total volume (" << volume << ", " << dvolume << ")" << endl;
		package->volumeChanged(volume, dvolume);
	}
	volume=dvolume;
	package->compLockAll();
}

float FMFile::getVolume() const {
	if(debug_level>1)
		cout << "FMFile::getVolume called" << endl;
	return volume;
}

void  FMFile::setFilemode(FileMode dm){
	if(debug_level>1)
		cout << "FMFile::setFilemode called" << endl;
	m = dm;
}

FileMode FMFile::getFilemode() const {
	if(debug_level>1)
		cout << "FMFile::getFilemode called" << endl;
	return m;
}

void  FMFile::setMLen(float dmlen){
	if(debug_level>1)
		cout << "FMFile::setMLen called" << endl;
	mlen = dmlen;
}

float FMFile::getMLen() const {
	return mlen;
}

void  FMFile::setAnti(bool danti){
	if(debug_level>1)
		cout << "FMFile::setAnti(" << danti << ") called" << endl;
	anti = danti;
}

bool  FMFile::getAnti() const {
	if(debug_level>1)
		cout << "FMFile::getAnti called" << endl;
	return anti;
}

void   FMFile::setFFreq(){
	if(debug_level>1)
		cout << "FMFile::setFFreq called" << endl;
	if(!ffreq){
		ffreq = new FMHFFile(package,0.0,freq);
	}
}

void   FMFile::unsetFFreq(){
	if(debug_level>1)
		cout << "FMFile::unsetFFreq called" << endl;
	if(ffreq){
		delete ffreq;
		ffreq=0;
		package->compLockAll();
	}
}

void   FMFile::setHVol(){
	if(debug_level>1)
		cout << "FMFile::setHVol called" << endl;
	if(!hvol)
		hvol = new FMHFFile(package,0.0,1.0);
}

void   FMFile::unsetHVol(){
	if(debug_level>1)
		cout << "FMFile::unsetHVol called" << endl;
	if(hvol){
		delete hvol;
		hvol=0;
		package->compLockAll();
	}
}

void   FMFile::setMLM(){
	if(debug_level>1)
		cout << "FMFile::setMLM called" << endl;
	if(!mlm)
		mlm = new FMHFFile(package,0.0,mlen);
}

void   FMFile::unsetMLM(){
	if(debug_level>1)
		cout << "FMFile::unsetMLM called" << endl;
	if(mlm){
		delete mlm;
		mlm=0;
		package->compLockAll();
	}
}

void   FMFile::setRNF(){
	if(debug_level>1)
		cout << "FMFile::setRNF called" << endl;
	if(!rnf)
		rnf = new FMFile(package);
}

void   FMFile::unsetRNF(){
	if(debug_level>1)
		cout << "FMFile::unsetRNF called" << endl;
	if(rnf){
		delete rnf;
		rnf=0;
		package->compLockAll();
	}
}

void   FMFile::setAtime(float datime) {
	if(debug_level>1)
		cout << "FMFile::setAtime called" << endl;
	atime = datime; /*should there be a comp_lock=0 here?*/ 
}

void   FMFile::incAtime() {
  if(mode==0)
    atime = fmod((atime + getVlen() * freq / package->channel->player->getRate()), getVlen());
  if(mode==1)
	  atime = fmod((atime + vtl[getVlen()-1].getTime() * freq / package->channel->player->getRate()),
		vtl[getVlen()-1].getTime());
	if(mode==3)
		atime = fmod((atime+2.0*PI*freq/float(package->channel->player->getRate())),2.0*PI);
}

void   FMFile::openFile() {
  if(debug_level)
	 cout << "FMFile::openFile called, filename: " << filename << endl;
	try{
		if(filename && !open_lock)
			init(filename);
		else if(!filename){
			cout << "FIF_NFNM_ERR" << endl;
			throw FIF_NFNM_ERR;
		}
		if(hvol)
			hvol->openFile();
		if(ffreq)
			ffreq->openFile();
		if(mlm)
			mlm->openFile();
		if(rnf)
			rnf->openFile();
		open_lock=1;
	}
	catch(...){
		throw;
		open_lock=0;
	}
}

void   FMFile::closeFile() {
	if(debug_level>1)
		cout << "FMFile::closeFile called" << endl;
	if(filename)
		cleanup();
	open_lock=0;
}

float  FMFile::value(bool count_on){

	float avalue = 0.0;

	if(mlm){
		mlen = mlm->HFValue(count_on);
		//cout << mlen << endl;
	}

	if(m == Sound){
		avalue = fmval(this, atime);

		if(count_on){
			if(ffreq)
				freq = ffreq->HFValue();
			incAtime();
		}
	}

	if(m == Noise){
		if(till<=0){
			till = int(fmrand(this, mlen))+1;
			nval = float(rand() % 255999) / 1000.0;
		}
		avalue = nval;
		if(count_on)
			till--;
	}

	if(m == NoiseRand){
		if(till<=0){
			till = int(fmrand(this, mlen))+1;
			nval = fmrand(rnf ? rnf : this, 128.0);
		}
		avalue = nval;
		if(count_on)
			till--;
	}

	if(m == RandNoise){
		if(till<=0){
			till = int(fmrand(rnf ? rnf : this, rnf ? rnf->getMLen() : mlen))+1;
			nval = fmrand(this, 128.0);
		}
		avalue = nval;
		if(count_on)
			till--;
	}

	if(m == Rand){
		avalue = fmrand(this, 128.0);
	}

	if(hvol){
			avalue = hvol->HVolVal(avalue);
	}

	return anti ? (avalue * -1.0) + 255.0 : avalue;
}

int FMFile::rval(){
 if(debug_level>1)
 	cout << "FMFile::rval called" << endl;
 int drval = 1;
 if(m == Sound){
	if(ffreq){
		freq = 0.5*(ffreq->getMax()+ffreq->getMin());
		drval = int(kgv(drval,ffreq->rval()));
		if(freq < ffreq->getFreq()*package->channel->player->getFFFuzzyness())
			drval = int(kgv(drval, package->channel->player->getRate() / freq));
	}
	else
		drval = int(kgv(drval,package->channel->player->getRate() / freq));

	if(hvol)
		drval = int(kgv(drval, hvol->rval()));
	if(mlm)
		drval = int(kgv(drval, mlm->rval()));
	if(rnf)
		drval = int(kgv(drval, rnf->rval()));
	if(drval < 0.0 || drval > package->channel->player->getRate() * package->getTime())
		drval = int(package->channel->player->getRate() * package->getTime());
 }
 else
    drval = int(package->channel->player->getRate() * package->getTime());
	return drval;
}

/*----------------------------------------------------------------*/

