/**************************************************************************
                    fmplayer.cpp  -  all the FMPlayer-API
                            -------------------
    begin                : September 20th 2002
    copyright            : (C) 2002-2003 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "include/fmplayer.h"

using namespace std;

/*----------------------------------------------------------------*/

FMHFFile::FMHFFile(FMPackage *parentPackage, float dmin, float dmax) : FMFile(parentPackage){
	if(debug_level>1)
		cout << "FMHFFile::FMHFFile called" << endl;
	min    = dmin;
	max    = dmax;
	minh   = 0;
	maxh   = 0;
	iter   = 1.0;
	miniter = maxiter = -1.0;
	comp_lock=0;
	m      = Envelope;
}

FMHFFile::~FMHFFile(){
	if(debug_level>1)
		cout << "FMHFFile::~FMHFFile called" << endl;
	if(minh)
		delete minh;
	if(maxh)
		delete maxh;
	if(debug_level>1)
		cout << "FMHFFile::~FMHFFile finished" << endl;
}

void FMHFFile::openFile(){
	FMFile::openFile();
	if(minh)
		minh->openFile();
	if(maxh)
		maxh->openFile();
}

void FMHFFile::setFFreq(){
	if(miniter==maxiter==-1.0){
		miniter = 0.0;
		maxiter = iter;
		// again, same problem as with
		// FMFile::setFreq()
	}
	FMFile::setFFreq();
}

void FMHFFile::setMode(HFMode dm){
	m = dm;
	comp_lock=0;
	package->compLockAll();
}

HFMode FMHFFile::getMode() const {
	return m;
}

bool FMHFFile::compLock(){
	if(debug_level>1)
		cout << "FMHFFile::compLock called" << endl;
	if(!FMFile::compLock())
		return 0;
	return comp_lock;
}

void FMHFFile::compLockMe(){
	if(debug_level>1)
		cout << "FMHFFile::compLockMe called" << endl;
	comp_lock=0;
	if(ffreq)
		ffreq->compLockMe();
	if(hvol)
		hvol->compLockMe();
	if(mlm)
		mlm->compLockMe();
}

float FMHFFile::HFValue(bool count_on){
 float dmin = minh ? minh->HFValue(count_on) : min;
 float dmax = maxh ? maxh->HFValue(count_on) : max;
 if(debug_level>1 && dmax < dmin)
 	cout << "error: FMHFFile::max<FMHFFile::min" << endl;
 return (dmax-dmin)/255.0 * FMFile::value(count_on) + dmin;
 //cout << dmax << " " << x << " " << dmin << " " << FMFile::value(0) << endl;
 //return x;
}

void  FMHFFile::compute(){
	if(debug_level>1)
		cout << "FMHFFile::compute called" << endl;
	freq   = iter / package->getTime();
	if(debug_level>1) cout << "set HFFFile::freq=iter/time=" << iter << "/" << package->getTime() << endl;
	if(freq>100&&debug_level) cout << "WARNING: HIGH FMHFFILE FREQUENCY" << endl;
	if(mode==2) cout << "WARNING: WRONG MODE FOR FMHFFILE" << endl;
	if(ffreq){
		if(debug_level>1)
			cout << "need to set FMHFFile::ffreq min and max" << endl;
		ffreq->setMin(miniter / package->getTime());
		ffreq->setMax(maxiter / package->getTime());
		//ffreq->compute();
	}
	if(max<min){
		if(debug_level)
			cout << "max<min: set min to " << max << endl;
		min = max;
	}
	if(minh){
		if(minh->getMax() > (maxh ? maxh->getMin() : max)){
			if(debug_level)
				cout << "minh->max too high, set to " << (maxh ? maxh->getMin() : max) << endl;
			minh->setMax(maxh ? maxh->getMin() : max);
		}
		minh->compute();
	}
	if(maxh){
		if(maxh->getMin() < (minh ? minh->getMax() : min)){
			if(debug_level)
				cout << "maxh->min too low, set to " << (minh ? minh->getMax() : min) << endl;
			maxh->setMin(minh ? minh->getMax() : min);
		}
		maxh->compute();
	}

	FMFile::compute();
	comp_lock=1;
}

float FMHFFile::HVolVal(float aval){
  float x = aval;
	if(m==Envelope)
		x = aval * HFValue();
	if(m==AmpMod)
		x = aval * HFValue(0) + (1.0-HFValue())*128.0;
	if(m==Ring)
		x = ((aval-128.0) * (value()-128.0)/128.0)+128.0;
 return x;
}

float FMHFFile::getMin() const {
	if(debug_level>1)
		cout << "FMHFFile::getMin called" << endl;
	return min;
}

void  FMHFFile::setMin(float dmin){
	if(debug_level>1)
		cout << "FMHFFile::setMin called, min=" << min << endl;
	min = dmin;
	comp_lock=0;
}

float FMHFFile::getMax() const {
	if(debug_level>1)
		cout << "FMHFFile::getMax called" << endl;
	return max;
}

void  FMHFFile::setMax(float dmax){
	if(debug_level>1)
		cout << "FMHFFile::setMax called, max=" << max << endl;
	max = dmax;
	if(max < min)
		max = min;
	comp_lock=0;
}

float FMHFFile::getIter() const {
	if(debug_level>1)
		cout << "FMHFFile::getIter called" << endl;
	return iter;
}

void  FMHFFile::setIter(float diter) {
	if(debug_level>1)
		cout << "FMHFFile::setIter called, iter=" << diter << endl;
	iter = diter;
	comp_lock=0;
}

float FMHFFile::getMinIter() const {
	if(debug_level>1)
		cout << "FMHFFile::getMinIter called" << endl;
	return miniter;
}

void  FMHFFile::setMinIter(float dminiter) {
	if(debug_level>1)
		cout << "FMHFFile::setMinIter called, miniter=" << dminiter << endl;
	miniter = dminiter;
	comp_lock=0;
}

float FMHFFile::getMaxIter() const {
	if(debug_level>1)
		cout << "FMHFFile::getMaxIter called" << endl;
	return maxiter;
}

void  FMHFFile::setMaxIter(float dmaxiter) {
	if(debug_level>1)
		cout << "FMHFFile::setMaxIter called, maxiter=" << dmaxiter << endl;
	maxiter = dmaxiter;
	comp_lock=0;
}

void   FMHFFile::setMinH(){
	if(debug_level>1)
		cout << "FMHFFile::setMinH called" << endl;
	if(!minh)
		minh = new FMHFFile(package,min,max/2.0);
}

void   FMHFFile::unsetMinH(){
	if(debug_level>1)
		cout << "FMHFFile::unsetMinH called" << endl;
	if(minh){
		delete minh;
		minh=0;
		package->compLockAll();
	}
}

void   FMHFFile::setMaxH(){
	if(debug_level>1)
		cout << "FMHFFile::setMaxH called" << endl;
	if(!maxh)
		maxh = new FMHFFile(package,max/2.0,max);
}

void   FMHFFile::unsetMaxH(){
	if(debug_level>1)
		cout << "FMHFFile::unsetMaxH called" << endl;
	if(maxh){
		delete maxh;
		maxh=0;
		package->compLockAll();
	}
}

int  FMHFFile::rval(){
	int drval = FMFile::rval();
	if(minh)
		drval = int(kgv(drval,minh->rval()));
	if(maxh)
		drval = int(kgv(drval,maxh->rval()));
	if(drval < 0.0 || drval > package->channel->player->getRate() * package->getTime())
		drval = int(package->channel->player->getRate() * package->getTime());
	return drval;
}

/*----------------------------------------------------------------*/

