/**************************************************************************
                    fmplayer.cpp  -  all the FMPlayer-API
                            -------------------
    begin                : September 20th 2002
    copyright            : (C) 2002-2003 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "include/fmplayer.h"

using namespace std;

/*----------------------------------------------------------------*/


FMMidi::FMMidi(FMFile *parent) {
	if(debug_level>1)
		cout << "FMMidi::FMMidi called" << endl;

	midifile = parent;
	fakePackage = new FMPackage(midifile->package->channel);

	for(int i=0; i<32; i++){
		//cout << i << endl;
		g[i] = 0; //new FMSoundfile(fakePackage);
	}
	
	setMidiI(0,DATADIR "/sounds/sin");

	bps = 0;

	rt = -1;
	rv = 0;
	if(debug_level>1)
		cout << "FMMidi::FMMidi finished" << endl;
}

float FMMidi::MidiValue(bool count_on) {
	//cout << "Midi still standing a0" << " " << endl;
	if(rv==0){ // we need to switch to another tone
		//cout << "Midi still standing b0" << endl;
		rt=rt+1;
		//cout << "Midi still standing b1" << endl;
		//rt = rt % midifile->getVlen();
		// avoid to take a tone that doesn't exit - but do we need that?
		fakePackage->setTime(midifile->pbs[rt].beats / bps);
		//cout << "Midi still standing b2" << endl;
		// time of our new tone
		if(debug_level)
			cout << midifile->pbs[rt].beats << " beats, " << bps << " bps, "
			<< fakePackage->getTime() << " s" << endl;
		//cout << "Midi still standing b3" << endl;
		g[midifile->pbs[rt].style]->setFreq(midifile->pbs[rt].pitch *
											midifile->getFreq());
		// set frequency, and beware of chords
		if(midifile->pbs[rt].style==31){ // oh my god, it's a chord!
			// we should handle different chords, but for the time being...
	        double q1,q2;
		double q = pow(2.0,1.0/12.0); // Halbtonschritt
			cout << "chord type " << midifile->pbs[rt].chord << endl;
			switch(midifile->pbs[rt].chord){
				// quintbasierte Akkorde
				case 1: // sus2 (C-D-G)
					//q1=5.0/4.0; q2=3.0/2.0;
					q1=pow(q,3-1); q2=pow(q,8-1);
					break;
				case 2: // Moll (C-Es-G)
					//q1=6.0/5.0; q2=3.0/2.0;
					q1=pow(q,4-1); q2=pow(q,8-1);
					break;
				case 0:
				case 3: // Dur (C-E-G)
					q1=pow(q,5-1); q2=pow(q,8-1);
					//q1=9.0/8.0; q2=3.0/2.0;
					break;
				case 4: // sus4 (C-F-G)
					q1=pow(q,6-1); q2=pow(q,8-1);
					//q1=4.0/3.0; q2=3.0/2.0;
					break;
				case 5: // quint-gr.sext
					q1=pow(q,10-1); q2=pow(q,8-1);
					break;
				case 6: // quint-kl.sept
					q1=pow(q,11-1); q2=pow(q,8-1);
					break;
				case 7: // quint-gr.sept
					q1=pow(q,12-1); q2=pow(q,8-1);
					break;
				case 8: // oktaviert (C-G-C)
					q1=pow(q,13-1);

				// quartbasierte Akkorde
				case 17: // quart-sekund (C-D-F)
					q1=pow(q,3-1); q2=pow(q,6-1);
					break;
				case 18: // quart-kleine terz (C-Dis-F)
					q1=pow(q,4-1); q2=pow(q,6-1);
					break;
				case 19: // quart-quint, redundant with sus4 (C-F-G)
					q1=pow(q,8-1); q2=pow(q,6-1);
					break;
				case 20: // quart-kleine sext (C-F-Gis)
					q1=pow(q,9-1); q2=pow(q,6-1);
					break;
				case 21: // quart-gr.sext (C-F-A)
					q1=pow(q,10-1); q2=pow(q,6-1);
					break;
				case 22: // quart-kleine sept (C-F-B)
					q1=pow(q,11-1); q2=pow(q,6-1);
					break;
				case 23: // quart-gr. sept (C-F-B)
					q1=pow(q,12-1); q2=pow(q,6-1);
					break;
				case 24: // quart-oktav (C-F-B)
					q1=pow(q,13-1); q2=pow(q,6-1);
					break;

				// gr. Terzbasierte Akkorde
				case 33: // terz-kl.sekund (C-Cis-E)
					q1=pow(q,2-1); q2=pow(q,5-1);
					break;
				case 34: // terz-sekund (C-D-E)
					q1=pow(q,3-1); q2=pow(q,5-1);
					break;
				case 35: // terz-kl.terz (C-Dis-E)
					q1=pow(q,4-1); q2=pow(q,5-1);
					break;
				case 36: // terz-quart (C-E-F)
					q1=pow(q,6-1); q2=pow(q,5-1);
					break;
				case 37: // terz-tritonus (C-E-Fis)
					q1=pow(q,7-1); q2=pow(q,5-1);
					break;
				case 38: // terz-quint = Dur (C-E-G)
					q1=pow(q,8-1); q2=pow(q,5-1);
					break;
				case 39: // terz-kl.sext (C-E-Gis)
					q1=pow(q,9-1); q2=pow(q,5-1);
					break;
				case 40: // terz-sext (C-E-A)
					q1=pow(q,10-1); q2=pow(q,5-1);
					break;
				case 41: // terz-kl.sept (C-E-B)
					q1=pow(q,11-1); q2=pow(q,5-1);
					break;
				case 42: // terz-gr.sept (C-E-H)
					q1=pow(q,12-1); q2=pow(q,5-1);
					break;
				case 43: // terz-oktav (C-E-C)
					q1=pow(q,13-1); q2=pow(q,5-1);
					break;

				// kl. Terzbasierte Akkorde
				case 49: // kl.terz-kl.sekund (C-Cis-Dis)
					q1=pow(q,2-1); q2=pow(q,4-1);
					break;
				case 50: // kl.terz-sekund (C-D-Dis)
					q1=pow(q,3-1); q2=pow(q,4-1);
					break;
				case 51: // kl.terz-gr.terz (C-Dis-E)
					q1=pow(q,5-1); q2=pow(q,4-1);
					break;
				case 52: // kl.terz-quart (C-Dis-F)
					q1=pow(q,6-1); q2=pow(q,4-1);
					break;
				case 53: // kl.terz-tritonus (C-Dis-Fis)
					q1=pow(q,7-1); q2=pow(q,4-1);
					break;
				case 54: // kl.terz-quint = Dur (C-Dis-G)
					q1=pow(q,8-1); q2=pow(q,4-1);
					break;
				case 55: // kl.terz-kl.sext (C-Dis-Gis)
					q1=pow(q,9-1); q2=pow(q,4-1);
					break;
				case 56: // kl.terz-sext (C-Dis-A)
					q1=pow(q,10-1); q2=pow(q,4-1);
					break;
				case 57: // kl.terz-kl.sept (C-Dis-B)
					q1=pow(q,11-1); q2=pow(q,4-1);
					break;
				case 58: // kl.terz-gr.sept (C-Dis-H)
					q1=pow(q,12-1); q2=pow(q,4-1);
					break;
				case 59: // kl.terz-oktav (C-Dis-C)
					q1=pow(q,13-1); q2=pow(q,4-1);
					break;

				default:
					q1=q2=1.0;
					if(debug_level)
					  cout << "unknown chord" << endl;
			}

			g[midifile->pbs[rt].style]->next
				->setFreq(midifile->pbs[rt].pitch *
				midifile->getFreq()*q1);
	        g[midifile->pbs[rt].style]->next->next
				->setFreq(midifile->pbs[rt].pitch *
				midifile->getFreq()*q2);
		}

		if(g[midifile->pbs[rt].style]->hvol){
			g[midifile->pbs[rt].style]->hvol->setAtime(0.0);
			g[midifile->pbs[rt].style]->hvol->compute();
		}
	}
	//cout << "Midi still standing a1" << endl;
	if(count_on)
		rv++;
	if(rv >= fakePackage->getTime() * fakePackage->channel->player->getRate())
		rv = 0;
	if(midifile->pbs[rt].style==31){ // chord
		return (g[midifile->pbs[rt].style]->value(count_on) +
		        g[midifile->pbs[rt].style]->next->value(count_on) +
		        g[midifile->pbs[rt].style]->next->next->value(count_on))
				/ 3.0;

	}
	return g[midifile->pbs[rt].style]->value(count_on);
}


void FMMidi::initMidi() {
try{
if(!g[0]){
	throw MID_NDEF_ERR;
}
}
catch(...){
	cout <<  "catch error in FMMidi::initMidi" << endl;
	throw;
	return;
}
g[0]->openFile();
float tbeats = 0.0;
if(debug_level>1)
	cout << "initializing midifile with " << midifile->getVlen() << " tones" << endl;
int i;
for(i = 0; i < midifile->getVlen(); i++){
	tbeats += midifile->pbs[i].beats;
	if(debug_level>1)
		cout << "beats: " << tbeats << "  style: " << midifile->pbs[i].style << endl;

	if(g[midifile->pbs[i].style])
	if(g[midifile->pbs[i].style]->getMode() != -1){
      if(debug_level>1)
		cout << "midi " << i << ": file already opened" << endl;
		continue;
	}
	if(debug_level>1)
		cout << "going to check style... " << midifile->pbs[i].style << endl;

		if(!g[midifile->pbs[i].style])
			g[midifile->pbs[i].style] = new FMSoundfile(fakePackage);

		// default since some newer version: has auto-filename (sin) !
		//if(!g[midifile->pbs[i].style]->getFilename()){
		//	cout << "has no filename" << endl;
		//	g[midifile->pbs[i].style]->setFilename(g[0]->getFilename());
		//}

		g[midifile->pbs[i].style]->openFile(); // open it
		if(midifile->pbs[i].style==31){ // in case of a chord
			cout << "going to init chord" << endl;
			if(!g[31]->next)  // yes, we need all that crap!
				g[31]->next = new FMSoundfile(fakePackage);
			g[31]->next->setFilename(g[31]->getFilename());
			cout << "set filename" << endl;
			g[31]->next->openFile();
			if(!g[31]->next->next)
				g[31]->next->next = new FMSoundfile(fakePackage);
			g[31]->next->next->setFilename(g[31]->getFilename());
			g[31]->next->next->openFile();
			// should I also initialize the filenames here?
			cout << "init chord completed" << endl;
		}
	 if(debug_level>1)
		cout << "midi " << i << ": opened file regularily" << endl;
	//}
}
bps = tbeats / midifile->package->getTime();
if(debug_level)
	cout << "bps: " << bps;
if(g[0]->hvol){
g[0]->hvol->openFile();
for(int i = 1; i < 33; i++){
	if(g[i] && !g[i]->hvol){
		g[i]->setHVol();
		g[i]->hvol->setFilename(g[0]->hvol->getFilename());
		g[i]->hvol->openFile();
	}
}
}
fakePackage->setTVol(1.0);
}

void FMMidi::setMidiI(int nr, char * filename){

	if(debug_level>1)
		cout << "FMMidi::setMidiI called, nr=" << nr << ", filename=" << filename << endl;

	if(nr > 31 || nr < 0){
		if(debug_level>1)
			cout << "FMMidi::setMidiI finished: index too high or too low" << endl;
		return;
	}

	if(debug_level>1)
		cout << "checking for existing instrument with index " << nr << endl;

	if(!g[nr]){
		if(debug_level>1)
			cout << "creating new FMSoundfile for Midi instrument" << endl;
		g[nr] = new FMSoundfile(fakePackage);
	}

	g[nr]->setFilename(filename);

	if(nr==31){ // chord!
		g[nr]->next = new FMSoundfile(fakePackage);
		g[nr]->next->setFilename(filename);
		g[nr]->next->next = new FMSoundfile(fakePackage);
		g[nr]->next->next->setFilename(filename);
	}

	if(debug_level>1)
		cout << "FMMidi::setMidiI finished" << endl;

}


void FMMidi::setMidiH(int nr, char * filename){

	if(debug_level>1)
		cout << "FMMidi::setMidiH called" << endl;

	if(nr > 31 || nr < 0){
		if(debug_level)
			cout << "invalid mi nr " << nr << endl;
		return;
	}

	//if(!g[nr]){
	//	g[nr] = new FMSoundfile(fakePackage);
	//}

	g[nr]->setHVol();
	g[nr]->hvol->setFilename(filename);
	//g[nr]->hvol->setMax(1);
	//g[nr]->hvol->setMin(0);


	if(debug_level>1)
		cout << "FMMidi::setMidiH finished" << endl;
}

float FMMidi::getMidiHMin(int nr){
	if(nr > 31 || nr < 0 || !g[nr])
		return 0.0;
	if(g[nr]->hvol)
		return g[nr]->hvol->getMin();
	return 0.0;
}

void FMMidi::setMidiHMin(int nr, float dhmin) {
	if(nr > 31 || nr < 0 || dhmin >= 1 || dhmin < 0 || !g[nr]){
		if(debug_level)
			cout << "invalid hmin" << endl;
		return;
	}
	if(g[nr]->hvol)
		g[nr]->hvol->setMin(dhmin);
}

float FMMidi::getMidiHMax(int nr){
	if(nr > 31 || nr < 0 || !g[nr])
		return 1.0;
	if(g[nr]->hvol)
		return g[nr]->hvol->getMax();
	return 1.0;
}

void FMMidi::setMidiHMax(int nr, float dhmax) {
	if(nr > 31 || nr < 0 || dhmax <= 0 || dhmax > 1 || !g[nr]){
		if(debug_level)
			cout << "invalid hmax" << endl;
		return;
	}
	if(g[nr]->hvol)
		g[nr]->hvol->setMax(dhmax);
}

float FMMidi::getMidiHIter(int nr){
	if(nr > 31 || nr < 0 || !g[nr])
		return 1.0;
	if(g[nr]->hvol)
		return g[nr]->hvol->getIter();
	return 0.0;
}

void FMMidi::setMidiHIter(int nr, float dhiter) {
	if(nr > 31 || nr < 0 || !g[nr])
		return;
	if(g[nr]->hvol)
		g[nr]->hvol->setIter(dhiter);
}

float  FMMidi::getMidiVol(int nr) {
	if(nr > 31 || nr < 0 || !g[nr])
		return 1.0;
	return g[nr]->getVolume();
}

void   FMMidi::setMidiVol(int nr, float dvol) {
	if(nr > 31 || nr < 0 || !g[nr])
		return;
	g[nr]->setVolume(dvol,0);
}

double FMMidi::getBps() {return bps; }

void   FMMidi::setBps(double dbps) {bps = dbps; }


/*-------------------------------------------------------------------------*/

