/**************************************************************************
                    fmplayer.cpp  -  all the FMPlayer-API
                            -------------------
    begin                : September 20th 2002
    copyright            : (C) 2002-2003 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "include/fmplayer.h"

using namespace std;

/*----------------------------------------------------------------*/

int FMPackage::lfd_nr = 1;

FMPackage::FMPackage(FMChannel *parentChannel){
	if(debug_level>1)
		cout << "FMPackage::FMPackage called" << endl;
	channel = parentChannel;
	if(channel == channel->player->first)
		other = channel->player->second;
	else
		other = channel->player->first;

	self   = this;
	next   = 0;
	hvol   = 0;
	tvol   = 0.0; // have to do this before FMSoundfile::FMSoundfile(this)
	sound  = new FMSoundfile(this);
	first  = sound;
	time   = 1.0;
	vol    = 1.0;
	repeat = 1.0;
	rval   = 0;
	nr     = lfd_nr;
	values = 0;
	recursive_delete = 1;
	lfd_nr++;
	comp_lock=0;
}

FMPackage::~FMPackage() {
	if(debug_level>1)
		cout << "FMPackage::~FMPackage " << nr << " called" << endl;
	if(next&&recursive_delete)
		delete next;
	delete first;
	if(hvol)
		delete hvol;
	if(values && self==this)
		delete []values;
	if(debug_level>1)
		cout << "FMPackage::~FMPackage " << nr << " finished" << endl;
}

void FMPackage::deleteMe(){
	if(debug_level>1)
		cout << "FMPackage::deleteMe called" << endl;
       if(this==channel->first)
               return;
       FMPackage * before = channel->first;
       while(before->next && before->next != this){
         before = before->next;
       }
       if(!next){
         before->next = 0;
       }
       else{
         before->next = next;
       }
       channel->package = channel->first;
       while(channel->package->next)
         channel->package = channel->package->next;
       recursive_delete = 0;
       delete this;
}

void FMPackage::nextSound() {
	if(debug_level>1)
		cout << "FMPackage::nextSound called" << endl;
	if(!sound->next){
		sound->next = new FMSoundfile(this);
		comp_lock=0;
	}
	sound = sound->next;
}

void FMPackage::firstSound() {
	if(debug_level>1)
		cout << "FMPackage::firstSound called" << endl;
	sound = first;
}

bool FMPackage::isFirstSound() {
	return (sound==first);
}

float FMPackage::getTime() const {
	return time;
}

void  FMPackage::setTime(float dtime) {
	if(debug_level>1)
		cout << "FMPackage::setTime called" << endl;
	time = dtime;
	compLockAll();
	if(debug_level>1)
		cout << "FMPackage::setTime finished" << endl;
}

float FMPackage::getVolume() const {
	if(debug_level>1)
		cout << "FMPackage::getVolume called" << endl;
	return vol;
}

void  FMPackage::setVolume(float dvol) {
	if(debug_level>1)
		cout << "FMPackage::setVolume called" << endl;
	vol = dvol; comp_lock=0;
}

int   FMPackage::getRval() const {
	return rval;
}

float FMPackage::getRepeat() const {
	return repeat;
}

void FMPackage::setTVol(float dtvol) {
	if(debug_level>1)
		cout << "FMPackage::setTVol called" << endl;
	tvol = dtvol;
}

float FMPackage::getTVol() const {
	return tvol;
}

void  FMPackage::setRepeat(float drepeat) {
	if(debug_level>1)
		cout << "FMPackage::setRepeat called" << endl;
	repeat = drepeat;
}

void  FMPackage::setSelf(FMPackage *dself) {
	if(debug_level>1)
		cout << "FMPackage::setSelf called" << endl;
	self = dself; comp_lock=0;
}

void  FMPackage::setSelf(int selfnr) {
	if(debug_level>1)
		cout << "FMPackage::setSelf called" << endl;
	comp_lock=0;
	FMPackage * tmpself;
	tmpself = channel->first;

	while(tmpself->getNr() < selfnr && tmpself->next)
		tmpself = tmpself->next;
	if(tmpself->getNr() == selfnr)
		self = tmpself;
	else
		cerr << "Unexpected Error 1" << endl;
}

void  FMPackage::setHVol() {
	if(debug_level>1)
		cout << "FMPackage::setHVol called" << endl;
	if(!hvol){
		hvol = new FMHFFile(this,0.0,1.0);
		comp_lock=0;
	}
}

int   FMPackage::getNr() const {
	if(debug_level>1)
		cout << "FMPackage::getNr called" << endl;
	return nr;
}

void  FMPackage::volumeChanged(float oldv, float newv){
	if(debug_level>1)
		cout << "FMPackage::volumeChanged called" << endl << "Volume changed: " << tvol << " - ";
	tvol += newv - oldv;
	if(debug_level>1)
		cout << tvol << endl;
	comp_lock=0;
	if(debug_level>1)
		cout << "FMPackage::volumeChanged finished" << endl;
}

void  FMPackage::openFiles() {
	if(debug_level>1)
		cout << "FMPackage::openFiles called" << endl;
	try{
	if(self==this){
		if(hvol && !hvol->openLock())
			hvol->openFile();
		FMSoundfile * tmpsound = first;
		while(tmpsound){
			if(!tmpsound->openLock()){
				if(debug_level>1)
				cout << "need to open this soundfile" << endl;
				tmpsound->openFile();
			}
			tmpsound = tmpsound->next;
			if(debug_level>1)
				cout << "opening of one file finished" << endl;
		}
		if(debug_level)
			cout << "opening of all files in package " << nr << " finished" << endl;
	}
	}
	catch(int i){
		cout <<  "caught error " << i << " in FMPackage::openFiles" << endl;
		throw;
	}
}


void  FMPackage::compute() {
	if(debug_level>1)
		cout << "FMPackage::compute called" << endl;
	if(hvol && !hvol->compLock())
			hvol->compute();
	if(comp_lock){
		FMSoundfile * tmp = first;
		bool ac = 1;
		while(tmp){
			ac = ac * tmp->compLock();
			tmp = tmp->next;
		}
		if(ac){
			if(debug_level)
				cout << "already computed" << endl;
			return;
		}
	}

	if(values && self==this){
		if(debug_level)
			cout << "recomputing package" << endl;
		delete []values;
	}

	if(self!=this){
		self->compute();
		values = self->values;
		rval = self->getRval();
		return;
	}

	// first, how many values do we need?
	rval = 1;
	//int numsounds = 0;
	FMSoundfile *tmpsound = first;
	while(tmpsound){
		//numsounds++;
		tmpsound->compute();
		tmpsound->setAtime(0.0);
		//tmpsound->setVolume(tmpsound->getVolume() / tvol, 0); 
		// don't set total volume, that's the reason for 0
		rval = int(kgv(rval, tmpsound->rval()));
		tmpsound = tmpsound->next;
	}

	if(hvol){
		rval = int(kgv(rval, hvol->rval()));
	}

	if(rval > channel->player->getRate() * time || rval < 0)
		rval = int(channel->player->getRate() * time);


	// ok, so we'll make a new value array
	if(debug_level>1)
		cout << rval << " values will be computed in package " << nr << endl;
	values = new float[rval];
	ptr = values;
	if(debug_level>1)
		cout << "values starting @ " << ptr << endl;

	// and now, we'll actually compute the values

	float phvol = vol; // if we don't have a phvol file, this will simply stay

	while(ptr < values+rval){
		//cout << "still standing" << endl;
		*ptr = 0.0;
		if(hvol)
			phvol = hvol->HFValue();
		//cout << "still standing 2" << endl;
		tmpsound = first;
		//cout << "still standing 3" << endl;
		while(tmpsound){
		//	cout << "still standing 4" << endl;
			*ptr = *ptr + tmpsound->value() * phvol;// / float(numsounds));
		//	cout << "still standing 5" << endl;
			//if(tmpsound->ffreq)
			//	tmpsound->setFreq(tmpsound->ffreq->HFValue());
			tmpsound = tmpsound->next;
		//	cout << "still standing 6" << endl;
		}
		//cout << "still standing 7" << endl;
		ptr++;
	}
	comp_lock=1;
	if(debug_level>1)
		cout << "FMPackage::compute finished after computing" << endl;
}

void FMPackage::compLockAll(){
	if(debug_level>1)
		cout << "FMPackage::compLockAll called" << endl;
	FMSoundfile * tmp = first;
	while(tmp){
		if(tmp->hvol)
			tmp->hvol->compLockMe();
		if(tmp->ffreq)
			tmp->ffreq->compLockMe();
		if(tmp->mlm)
			tmp->mlm->compLockMe();
		tmp = tmp->next;
	}
	if(hvol)
		hvol->compLockMe();
	comp_lock=0;
	if(debug_level>1)
		cout << "FMPackage::compLockAll finished" << endl;
}

/*----------------------------------------------------------------*/

