/**************************************************************************
                    fmplayer.cpp  -  all the FMPlayer-API
                            -------------------
    begin                : September 20th 2002
    copyright            : (C) 2002-2003 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "include/fmplayer.h"

using namespace std;

int dspfd = 0;

/*----------------------------------------------------------------*/

FMPlayer::FMPlayer() {
	if(debug_level>1)
		cout << "FMPlayer::FMPlayer called" << endl;
	first   = new FMChannel(this);
	channel = first;
	second  = 0;
	syncPointer();
	rate    = D_SAMPRATE;
	bytes   = D_BYTES;
	fffuzzyness = 10.0;
	mode    = DSP;
	wavfile = "output.wav";
	srand(time((time_t *)NULL));
	if(debug_level>1)
		cout << "FMPlayer::FMPlayer finished" << endl;
}

FMPlayer::~FMPlayer() {
	if(debug_level>1)
		cout << "FMPlayer::~FMPlayer called" << endl;
	delete first;
	if(second)
		delete second;
	if(debug_level>1)
		cout << "FMPlayer::~FMPlayer finished" << endl;
}

void FMPlayer::switchChannel() {
	if(debug_level>1)
		cout << "FMPlayer::switchChannel called" << endl;
	if(channel==second)
		channel = first;

	if(channel==first && second)
		channel = second;

	if(channel==first && !second){
		second  = new FMChannel(this);
		channel = second;
		//rate = int(rate / 2.0);
	}
	
	syncPointer();
}

void FMPlayer::firstChannel() {
	if(debug_level>1)
		cout << "FMPlayer::firstChannel called" << endl;
	channel = first;
	syncPointer();
}

void FMPlayer::nextPackage(bool create) {
	if(debug_level>1)
		cout << "FMPlayer::nextPackage called" << endl;
	channel->nextPackage(create);
	syncPointer();
}

void FMPlayer::firstPackage() {
	if(debug_level>1)
		cout << "FMPlayer::firstPackage called" << endl;
	channel->firstPackage();
	syncPointer();
}

void FMPlayer::nextSound() {
	if(debug_level>1)
		cout << "FMPlayer::nextSound called" << endl;
	channel->nextSound();
	syncPointer();
}

void FMPlayer::firstSound() {
	if(debug_level>1)
		cout << "FMPlayer::firstSound called" << endl;
	channel->firstSound();
	syncPointer();
}

void FMPlayer::resetPlayer() {
	if(debug_level>1)
		cout << "FMPlayer::resetPlayer called" << endl;
	delete first;
	if(second)
		delete second;
	first   = new FMChannel(this);
	channel = first;
	second  = 0;
	package = channel->package;
	sound   = channel->sound;
	rate    = D_SAMPRATE;
}

void FMPlayer::setRate(int drate) {
	if(debug_level>1)
		cout << "FMPlayer::setRate called" << endl;
	rate = drate;
	FMPackage *tmp = first->first;
	while(tmp){
		tmp->compLockAll();
		tmp = tmp->next;
	}
	if(second){
		tmp = second->first;
		while(tmp){
			tmp->compLockAll();
			tmp = tmp->next;
		}
	}
}

int  FMPlayer::getRate() const {
	return rate;
}

void FMPlayer::setBytes(int dbytes) {
	if(debug_level>1)
		cout << "FMPlayer::setBytes(" << dbytes << ") called" << endl;
	bytes = dbytes;
}

int FMPlayer::getBytes() const {
	if(debug_level>1)
		cout << "FMPlayer::getBytes called" << endl;
	return bytes;
}

void FMPlayer::setFFFuzzyness(float df) {
	if(debug_level>1)
		cout << "FMPlayer::setFFFuzzyness(" << df << ") called" << endl;
	fffuzzyness = df;
}

float FMPlayer::getFFFuzzyness() const {
	if(debug_level>1)
		cout << "FMPlayer::getFFFuzzyness called" << endl;
	return fffuzzyness;
}

void FMPlayer::setPlayMode(PlayMode dmode) {
	if(debug_level>1)
		cout << "FMPlayer::setPlayMode called" << endl;
	mode = dmode;
}

PlayMode  FMPlayer::getPlayMode() const {
	return mode;
}

void FMPlayer::setWavFile(char * dwavfile) {
	if(debug_level>1)
		cout << "FMPlayer::setWavFile called" << endl;
	wavfile = dwavfile;
	mode = WAV;
}

void FMPlayer::openFiles() {
	if(debug_level>1)
		cout << "FMPlayer::openFiles called" << endl;
 try{
	first->openFiles();
	if(second && second->play())
		second->openFiles();
 }
 catch(...){
 	cout <<  "caught error in FMPlayer::openFiles" << endl;
  throw;
 }
}

void FMPlayer::compute() {
	if(debug_level>1)
		cout << "FMPlayer::compute called" << endl;
	first->compute();
	if(second && second->play())
		second->compute();
}

void FMPlayer::syncPointer() {
	if(debug_level>1)
		cout << "FMPlayer::syncPointer called" << endl;
	package = channel->package;
	sound   = channel->sound;
}

void FMPlayer::play() {
 try{
	if(debug_level>1)
		cout << "FMPlayer::play called" << endl;
	openFiles();
	compute();
  playInit();
  while((first->ptr && first->play())|| (second && second->play() && second->ptr))
    playVal();
  playCleanup();
 }
 catch(int x){
 	if(x>0) // wenn's eine Fehlermeldung ist
	  throw;
 }
}

void FMPlayer::playInit() {
	if(debug_level>1)
		cout << "FMPlayer::playInit called" << endl;

#ifdef DSP_WORKS
	int format = AFMT_U8;
	if(bytes==2)
		format = AFMT_U16_LE;
	int chan = 0;
#endif

 	first->pointerReset();
	if(second && second->play())
		second->pointerReset();

 try{

#ifdef DSP_WORKS
	if(mode == DSP && !dspfd){
	
		if(debug_level>1)
			cout << "going to open and initialize /dev/dsp" << endl;

		if(second && second->play())
			chan = 1;

		if((dspfd = open("/dev/dsp", O_WRONLY)) == -1) {
			mode = NONE;
			dspfd = 0;
			throw DSP_OPEN_ERR;
			return;
		}

		if(ioctl(dspfd, SNDCTL_DSP_STEREO, &chan) == -1) {
			throw DSP_CHAN_ERR;
		}

		if(ioctl(dspfd, SNDCTL_DSP_SETFMT, &format) == -1) {
			throw DSP_SFMT_ERR;
		}

		if(ioctl(dspfd, SNDCTL_DSP_SPEED, &rate) == -1) {
			throw DSP_RATE_ERR;
		}
	}

	else 
#endif
	if(mode == WAV){

		int neededv1 = 0;
		int neededv2 = 0;
		FMPackage * tmppackage = first->first;

		while(tmppackage){
			neededv1 = neededv1 + int(rate * tmppackage->getTime()* tmppackage->getRepeat());
			tmppackage = tmppackage->next;
		}

		if(second && second->play()){
			tmppackage = second->first;
			while(tmppackage){
				neededv2 = neededv2 + int(rate * tmppackage->getTime() * tmppackage->getRepeat());
				tmppackage = tmppackage->next;
			}
			if(neededv2 > neededv1)
				neededv1 = neededv2;

			if(writeWavHeader(wavfile, neededv1 * 2 * bytes, rate, 1, bytes) == 0){
				throw WAV_OPEN_ERR;
				return;
			}
		}

		else{
			if(writeWavHeader(wavfile, neededv1 * bytes, rate, 0, bytes) == 0){
				throw WAV_OPEN_ERR;
				return;
			}
		}

	}

	else if(mode==NONE)
		return;

/*	else{
		if(debug_level)
			cout << "PlayMode " << mode << " not implemented!" << endl;
		throw PLY_MODE_ERR;
		return;
	}*/
 }

  catch(...){
  	throw;
  }

	if(debug_level>1)
		cout << "FMPlayer::playInit finished" << endl;
}

void FMPlayer::playVal(){

	char buff[2];

	if(bytes!=1 && bytes!=2){
		if(debug_level)
			cout << "bytes=" << bytes << ": not implemented" << endl;
		return;
	}

	if(second && second->play()){
		if(!first->ptr){
			buff[0] = 128;
		}
		else{
			if(bytes==1)
				buff[0] = int(*first->ptr/*-128.0*/);
			if(bytes==2){
				buff[0] = int(fmod(*first->ptr/*-128.0*/,1)*255.0);
				buff[1] = int(*first->ptr/*-128.0*/);
			}
			first->ptrInc();
		}
		writeSoundByte(buff, mode==WAV,bytes,dspfd);

		if(!second->ptr){
			buff[0] = 128;
		}
		else{
			if(bytes==1)
				buff[0] = int(*second->ptr/*-128.0*/);
			if(bytes==2){
				buff[0] = int(fmod(*second->ptr/*-128.0*/,1)*255.0);
				buff[1] = int(*second->ptr/*-128.0*/);
			}
			second->ptrInc();
		}
			writeSoundByte(buff, mode==WAV,bytes,dspfd);
	}

  else{
	if(bytes==1)
		buff[0] = int(*first->ptr/*-128.0*/);
	if(bytes==2){
		buff[0] = int(fmod(*first->ptr/*-128.0*/,1)*255.0);
		buff[1] = int(*first->ptr/*-128.0*/);
	}
	writeSoundByte(buff, mode==WAV, bytes, dspfd);
	first->ptrInc();
  }
}

void FMPlayer::playCleanup() {
	if(debug_level>1)
		cout << "FMPlayer::playCleanup called" << endl;
#ifdef DSP_WORKS
	if(mode == DSP){
    if(ioctl(dspfd, SNDCTL_DSP_SYNC) == -1) {
			throw DSP_SYNC_ERR;
		}
		close(dspfd); dspfd = 0;
  }
#endif
}

/*----------------------------------------------------------------*/

