/**************************************************************************
                    fmplayer.cpp  -  all the FMPlayer-API
                            -------------------
    begin                : September 20th 2002
    copyright            : (C) 2002-2003 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "include/fmplayer.h"

using namespace std;

/*----------------------------------------------------------------*/

FMSoundfile::FMSoundfile(FMPackage *parentPackage) : FMFile(parentPackage){
	if(debug_level>1)
		cout << "FMSoundfile::FMSoundfile called" << endl;
	midi    = 0;
	next    = 0;
	freq    = 441.0;
	package->volumeChanged(0.0, 1.0);
	if(debug_level>1)
		cout << "FMSoundfile::FMSoundfile finished" << endl;
}

FMSoundfile::~FMSoundfile(){
	if(debug_level>1)
		cout << "FMSoundfile::~FMSoundfile called" << endl;
	if(next)
		delete next;
	if(midi)
		delete midi;
	if(debug_level>1)
		cout << "FMSoundfile::~FMSoundfile finished" << endl;
}

void  FMSoundfile::setMidi(){
	if(debug_level>1)
		cout << "FMSoundfile::setMidi called" << endl;
	if(!midi){
		midi = new FMMidi(this);
		package->compLockAll();
	}
	if(debug_level>1)
		cout << "FMSoundfile::setMidi finished" << endl;
}

void  FMSoundfile::openFile(){
	if(debug_level>1)
		cout << "FMSoundfile::openFile called" << endl;
	FMFile::openFile();
	if(midi){
		midi->initMidi();
	}
}

float FMSoundfile::value(bool count_on){
	//cout << "FMSoundfile::value still standing 1" << endl;
	float x,y;
	switch(getMode()){
		case 0:
		case 1:
		case 3:
	//		cout << "FMSoundfile::value normal file" << endl;
			return FMFile::value(count_on) * (volume/package->getTVol());
		case 2:
	//		cout << "FMSoundfile::value midi" << endl;
			if(hvol)
				return hvol->HVolVal(midi->MidiValue(count_on)) * (volume/package->getTVol());
	//		cout << "FMSoundfile::value midi still standing 1" << endl;
	//		cout << midi->rt << " " << midi->rv << endl;
			x = midi->MidiValue(count_on);
	//		cout << "FMSoundfile::value midi still standing 2" << endl;
			y = (volume/package->getTVol());
	//		cout << "FMSoundfile::value midi still standing 3" << endl;
			return x * y;
		default:
	//		cout << "FMSoundfile::value dunno" << endl;
			return 0.0;
	}
}

int   FMSoundfile::rval(){
	if(getMode()==2)
		return int(package->channel->player->getRate() * package->getTime());
	
	return FMFile::rval();
}

/*----------------------------------------------------------------*/

