/**************************************************************************
                   fmplayer.h  -  all the FMPlayer-API
                            -------------------
    begin                : September 20th 2002
    copyright            : (C) 2002 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _FMPLAYERG_
#define _FMPLAYERG_

#include "version.h"

#include <cstdlib>
#include <cstring>
#include <cmath>
#include <ctime>
#include <iostream>
#include <unistd.h>
#include <fcntl.h>

#ifdef   DSP_WORKS
#include <sys/ioctl.h>
#include <sys/soundcard.h>
#endif

#include "fmifstream.h"
#include "fmval.h"
#include "fmwav.h"

#define D_SAMPRATE 44100
#define D_BYTES 2

// error messages
#define DSP_OPEN_ERR   0
#define DSP_CHAN_ERR   1
#define DSP_SFMT_ERR   2
#define DSP_RATE_ERR   3
#define DSP_SYNC_ERR   4

#define WAV_OPEN_ERR 100
#define WAV_WRIT_ERR 101

#define PLY_MODE_ERR 200

#define MID_NDEF_ERR 300

#define FIF_NFNM_ERR 400

// internal signals
#define ATIME_RETURN  -1

// default values
#define DEFAULT_FREQ 440

void   writeSoundByte(char * byte, bool wav, int bytes, int dspfd);

float  fmval(FMData *f, float atime);

float  ggt(float a, float b);

float  kgv(float a, float b);

/* forward declarations */

class FMMidi;

class FMChannel;
class FMPackage;
class FMSoundfile;
class FMHFFile;

enum PlayMode {
	DSP,
	WAV,
	NONE
};

enum FileMode {
	Sound,
	Noise,
	NoiseRand,
	RandNoise,
	Rand
};

enum HFMode {
	Envelope,
	AmpMod,
	Ring
};

class FMPlayer {
	public:
		FMPlayer();
		~FMPlayer();

		FMChannel   *first;
		FMChannel   *second;
		FMChannel   *channel;
		FMPackage   *package;
		FMSoundfile *sound;

		void switchChannel();
		void firstChannel();
		void nextPackage(bool create = 1);
		void firstPackage();
		void nextSound();
		void firstSound();
		void resetPlayer();
		void setRate(int drate);
		int  getRate() const;
		void setBytes(int dbytes);
		int  getBytes() const;
		void  setFFFuzzyness(float df);
		float getFFFuzzyness() const;
		void setPlayMode(PlayMode dmode);
		PlayMode getPlayMode() const;
		void setWavFile(char * dwavfile);
		void openFiles();
		void compute();
		void play();
		void playInit();
		void playVal();
		void playCleanup();

	private:
		void syncPointer();

		int   rate;
		int   bytes;
		float fffuzzyness;
		PlayMode mode;
		char * wavfile;
};

class FMChannel {
	public:
		FMChannel(FMPlayer *parentPlayer);
		~FMChannel();

		FMPlayer    *player;
		FMPackage   *package;
		FMPackage   *first;
		FMSoundfile *sound;

		float       *ptr;

		bool  play();
		void  setPlay(bool);
		void  nextPackage(bool create = 1);
		void  firstPackage();
		void  nextSound();
		void  firstSound();
		void  setRepeat(int drepeat);
		int   getRepeat() const;
		void  openFiles();
		void  compute();
		void  ptrInc();
		void  pointerReset();

	private:
		void  syncPointer();

		int   i;
		int   dr;
		int repeat;
		bool  do_play;
};

class FMPackage {
	public:
		FMPackage(FMChannel *parentChannel);
		~FMPackage();

		FMChannel   *channel;
		FMChannel   *  other;
		FMPackage   *   next;
		FMPackage   *   self;
		FMHFFile    *   hvol;
		FMSoundfile *  sound;

		float *values;

		void   nextSound();
		void   firstSound();
		bool   isFirstSound();
		float  getTime() const;
		void   setTime(float dtime);
		float  getVolume() const;
		void   setVolume(float dvol);
		float  getTVol() const;
		void   setTVol(float dtvol);
		float  getRepeat() const;
		void   setRepeat(float drepeat);
		int    getRval() const;
		void   setSelf(FMPackage *dself);
		void   setSelf(int selfnr);
		void   setHVol(); // only say "yes, we're using phvol"
		int    getNr() const;
		void   volumeChanged(float oldv, float newv);
		void   openFiles();
		void   compute();
		void   deleteMe();
		void   compLockAll();

	private:
		FMSoundfile *first;

		float time;
		float vol;
		float tvol;
		int   rval;
		float repeat;
		float *ptr;
		int   nr;
		bool  recursive_delete;
		static int lfd_nr;
		bool  comp_lock;
};

class FMFile : public FMData {
	public:
		FMFile(FMPackage *parentPackage);
		~FMFile();

		FMPackage *package;
		FMHFFile    *ffreq;
		FMHFFile     *hvol;
		FMHFFile      *mlm;
		FMFile        *rnf;

		bool  openLock();
		void  fakeOpen();
		bool  compLock();
		void  compute();
		void  setFilename(char *dfilename);
		void  setFilename(const char *dfilename);
		char *getFilename() const;
		void  setFreq(float dfreq);
		float getFreq() const;
		void  setVolume(float dvolume, bool setptvol=1);
		float getVolume() const;
		void  setFilemode(FileMode dm);
		FileMode getFilemode() const;
		void  setMLen(float dmlen);
		float getMLen() const;
		void  setAnti(bool danti);
		bool  getAnti() const;
		void  setAtime(float datime);
		void  incAtime();
		void  setFFreq();
		void  unsetFFreq();
		void  setHVol();
		void  unsetHVol();
		void  setMLM();
		void  unsetMLM();
		void  setRNF();
		void  unsetRNF();
		void  openFile();
		void  closeFile();
		int   rval();

	protected:
		float value(bool count_on=1);
		float nval;
		int   till;
		float freq;
		float volume;
		float atime;
		float mlen;
		char *filename;
		bool  open_lock;
		bool  anti;
		int   nr;
		static int lfd_nr;
		FileMode m;
};

class FMSoundfile : public FMFile {
	public:
		FMSoundfile(FMPackage *parentPackage);
		~FMSoundfile();

		FMMidi      * midi;
		FMSoundfile * next;

		void  setMidi();
		float value(bool count_on=1);
		void  openFile();
		int   rval();
};

class FMHFFile : public FMFile {
	public:
		FMHFFile(FMPackage *parentPackage, float dmin = 0.0, float dmax = 1.0);
		~FMHFFile();
		
		FMHFFile * maxh;
		FMHFFile * minh;

		float  HFValue(bool count_on=1);
		float  HVolVal(float);
		void   setFFreq();
		void   compLockMe();
		bool   compLock();
		void   setMin(float dmin);
		float  getMin() const;
		void   setMax(float dmax);
		float  getMax() const;
		void   setIter(float diter);
		float  getIter() const;
		void   setMinIter(float dminiter);
		float  getMinIter() const;
		void   setMaxIter(float dmaxiter);
		float  getMaxIter() const;
		void   setMaxH();
		void   unsetMaxH();
		void   setMinH();
		void   unsetMinH();
		void   setMode(HFMode dm);
		HFMode getMode() const;
		void   compute();
		void   openFile();
		int    rval();

	private:
		float  min;
		float  max;
		float  iter;
		float  maxiter;
		float  miniter;
		HFMode m;
		bool  comp_lock;
};

class FMMidi {
    public:
		FMMidi(FMFile * parent);
		void   initMidi();
		void   setMidiI(int nr, char * filename);
		void   setMidiH(int nr, char * filename);
		float  getMidiHMin(int nr);
		void   setMidiHMin(int nr, float dhmin);
		float  getMidiHMax(int nr);
		void   setMidiHMax(int nr, float dhmax);
		float  getMidiHIter(int nr);
		void   setMidiHIter(int nr, float dhiter);
		float  getMidiVol(int nr);
		void   setMidiVol(int nr, float dvol);
		double getBps();
		void   setBps(double dbps);
		float  MidiValue(bool count_on=1);

		int  rt; // recent tone
		int  rv; // value no. of recent tone

	private:
		FMPackage *package;
		FMPackage *fakePackage;
		FMSoundfile *g[33]; // need 32 Instruments
		FMFile *midifile;
		double bps;
};

#endif

