/**************************************************************************
               musplay.cpp  -  providing fms-file reading utility
                             -------------------
    begin                : April 10th 2004
    copyright            : (C) 2004 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "include/fmplayer.h"
#include "include/fmofstream.h"
#include "include/version.h"

using namespace std;

enum fgoto_result {
    GOTOOK,
    GOTOEOF
};

enum pbsconvert_result {
    PBSOK,
    PBSERROR
};

enum readtone_result
{
    RTOK,    // OK
    RTEOF,   // End Of File
    RTEOV,   // End Of Voice
    RTEOT,   // End Of Takt
    RTERROR  // Error
};

int fd,l,voices,line;
char buf[1];
char rnum[4];
char rokt[4];
char note[4];
bool f[7]={0,0,0,0,0,0,0}; // CF|DF|EF|FF|GF|AF|BF/HF   (b) -- globale Vorzeichen
bool s[7]={0,0,0,0,0,0,0}; // CS|DS|ES|FS|GS|AS|HS      (#)
bool fl[7]; bool sl[7]; // lokale Vorzeichen
float abeats; // abgearbeitete Beats im aktuellen Takt
bool comment=0;

bool isNote(char c)
{
    switch(c)
    {
        case 'A':
        case 'B':
        case 'C':
        case 'D':
        case 'E':
        case 'F':
        case 'G':
        case 'H':
	case 'N':
        case 'R':
        case '#':
        case 'b':
	case 's':
	case 'f':
	case 'S':
            return 1;
    }
    return 0;
}

bool isSign(char c)
{
    switch(c)
    {
        case 'A':
        case 'B':
        case 'C':
        case 'D':
        case 'E':
        case 'F':
        case 'G':
        case 'H':
            return 1;
    }
    return 0;
}

bool isNum(char c){
    switch(c)
    {
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
        case '.':
        case '[': // to make skipspace recognize it as music
        //case '^':
            return 1;
    }
    return 0;
}

fgoto_result skipcomment()
{
    l = 1;
    //while(buf[0]==' ' && l == 1)
    buf[0]=' '; // do I need this?
    while(buf[0]!='\'' && l == 1)
    {
	l = read(fd,buf,1);
	if(buf[0]=='\n')
		line++;
    }
    l = read(fd,buf,1);

    if(l!=1)
        return GOTOEOF;
    return GOTOOK;
}

fgoto_result skipspace()
{
    l = 1;
    //while(buf[0]==' ' && l == 1)
    buf[0]=' '; // do I need this?
    while(((!isNum(buf[0]) && !isNote(buf[0])) || comment) && l == 1)
    {
	l = read(fd,buf,1);
	if(buf[0]=='\n')
		line++;
	if(buf[0]=='\''){
		skipcomment();
	}
    }

    if(l!=1)
        return GOTOEOF;
    return GOTOOK;
}

fgoto_result countvoices()
{
    voices = 1;
    l = 1;
    while(buf[0]!='\\' && l==1)
    {
	l=read(fd,buf,1);
	if(buf[0]==';')
	    voices++;
    }
    if(l!=1)
	return GOTOEOF;
    if(debug_level)
        cout << voices << " Stimmen gefunden" << endl;
    return GOTOOK;
}

void addGlobalSign()
{
	if(debug_level)
		cout << "finde globale Vorzeichen..." << endl;
	while((l=read(fd,buf,1))==1&&buf[0]!=')')
	{
		if(isSign(buf[0]))
		{
			switch(buf[0])
			{
			  case 'C':
				if(debug_level>1)
			  		cout << "found: " << buf[0];
			  	read(fd,buf,1);
				if(debug_level>1)
					cout << buf[0] << endl;
				switch(buf[0])
				{
				  case 'F':
				  	f[0]=1;
					break;
				  case 'S':
				  	s[0]=1;
					break;
				  default:
				  	cout << "\aan error occured!" << endl;
					return;
				}
				break;
			  case 'D':
				if(debug_level>1)
			  		cout << "found: " << buf[0];
			  	read(fd,buf,1);
				if(debug_level>1)
					cout << buf[0] << endl;
				switch(buf[0])
				{
				  case 'F':
				  	f[1]=1;
					break;
				  case 'S':
				  	s[1]=1;
					break;
				  default:
				  	cout << "\aan error occured!" << endl;
					return;
				}
				break;
			  case 'E':
				if(debug_level>1)
			  		cout << "found: " << buf[0];
			  	read(fd,buf,1);
				if(debug_level>1)
					cout << buf[0] << endl;
				switch(buf[0])
				{
				  case 'F':
				  	f[2]=1;
					break;
				  case 'S':
				  	s[2]=1;
					break;
				  default:
				  	cout << "\aan error occured!" << endl;
					return;
				}
				break;
			  case 'F':
				if(debug_level>1)
			  		cout << "found: " << buf[0];
			  	read(fd,buf,1);
				if(debug_level>1)
					cout << buf[0] << endl;
				switch(buf[0])
				{
				  case 'F':
				  	f[3]=1;
					break;
				  case 'S':
				  	s[3]=1;
					break;
				  default:
				  	cout << "\aan error occured!" << endl;
					return;
				}
				break;
			  case 'G':
				if(debug_level>1)
			  		cout << "found: " << buf[0];
			  	read(fd,buf,1);
				if(debug_level>1)
					cout << buf[0] << endl;
				switch(buf[0])
				{
				  case 'F':
				  	f[4]=1;
					break;
				  case 'S':
				  	s[4]=1;
					break;
				  default:
				  	cout << "\aan error occured!" << endl;
					return;
				}
				break;
			  case 'A':
				if(debug_level>1)
			  		cout << "found: " << buf[0];
			  	read(fd,buf,1);
				if(debug_level>1)
					cout << buf[0] << endl;
				switch(buf[0])
				{
				  case 'F':
				  	f[5]=1;
					break;
				  case 'S':
				  	s[5]=1;
					break;
				  default:
				  	cout << "\aan error occured!" << endl;
					return;
				}
				break;
			  case 'H':
			  case 'B':
				if(debug_level>1)
			  		cout << "found: " << buf[0];
			  	read(fd,buf,1);
				if(debug_level>1)
					cout << buf[0] << endl;
				switch(buf[0])
				{
				  case 'F':
				  	f[6]=1;
					break;
				  case 'S':
				  	s[6]=1;
					break;
				  default:
				  	cout << "\aan error occured! " << int(buf[0]) << endl;
					return;
				}
				break;
			  default:
			  	cout << "\athis should be impossible to happen" << endl;
				return;
			}

		}
	}
}

fgoto_result findtakt()
{
    //cout << "finde Takt" << flush;
    l = 1;
    while((buf[0]!='/' || comment) && l == 1){ //  bis Takt kommt oder Ende
        l = read(fd,buf,1);
        if(buf[0]=='\'')
            comment = (!comment);
	if(buf[0]=='(' && !comment)
	    addGlobalSign();
	if(buf[0]=='\n')
	    line++;
    }
    if(l!=1)
        return GOTOEOF;
    return GOTOOK;
}

pbsconvert_result pitch(PBSP * m)
{
	if(debug_level>1){
	for(int j=0; j<7; j++){
    	if(sl[j]) cout << "#";
		if(fl[j]) cout << "b";
		if(!sl[j] && !fl[j]) cout << "-";
		cout << " ";
	}
	cout << endl;
	}

    int n = atoi(rokt)*12+12;
    if(debug_level>1)
    	cout << "note=" << note << ", offset=" << n << endl;
    switch(note[0]){
        case 'A':
            switch(note[1]){
		case '\0':
                    n += 0; if(fl[5]){n--;} if(sl[5]){n++;} break;
		case 'N':
		    n += 0; fl[5]=sl[5]=0; break;
                case '#':
                case 's':
		case 'S':
					sl[5]=1;
                    n += 1; break;
                case 'b':
		case 'F':
                case 'f':
					fl[5]=1;
                    n += 11; break;
                default:
                    m->pitch = 121; return PBSERROR;
            }
            break;
        case 'B':
            switch(note[1]){
                case '\0':
                    n += 2; if(fl[6]){n--;} if(sl[6]){n++;} break;
		case 'N':
		    n += 2; fl[6]=sl[6]=0; break;
                case '#':
                case 's':
		case 'S':
					sl[6]=1;
                    n += 3; break;
                case 'b':
		case 'F':
                case 'f':
					fl[6]=1;
                    n += 1; break;
                default:
                    m->pitch = 121; return PBSERROR;
            }
        break;
        case 'C':
            switch(note[1]){
                case '\0':
                    n += 3; if(fl[0]){n--;} if(sl[0]){n++;} break;
		case 'N':
 		    n += 3; fl[0]=sl[0]=0; break;
                case '#':
		case 'S':
                case 's':
					sl[0]=1;
                    n += 4; break;
                case 'b':
		case 'F':
                case 'f':
					fl[0]=1;
                    n += 2; break;
                default:
                    m->pitch = 121; return PBSERROR;
            }
        break;
        case 'D':
            switch(note[1]){
                case '\0':
                    n += 5; if(fl[1]){n--;} if(sl[1]){n++;} break;
		case 'N':
 		    n += 5; fl[1]=sl[1]=0; break;
                case '#':
                case 's':
		case 'S':
					sl[1]=1;
                    n += 6; break;
                case 'b':
		case 'F':
                case 'f':
					fl[1]=1;
                    n += 4; break;
                default:
                    m->pitch = 121; return PBSERROR;
            }
        break;
        case 'E':
            switch(note[1]){
                case '\0':
                    n += 7; if(fl[2]){n--;} if(sl[2]){n++;} break;
		case 'N':
		    n += 7; fl[2]=sl[2]=0; break;
                case '#':
                case 's':
		case 'S':
		    sl[2]=1;
                    n += 8; break;
                case 'b':
		case 'F':
                case 'f':
					fl[2]=1;
                    n += 6; break;
                default:
                    m->pitch = 121; return PBSERROR;
            }
        break;
        case 'F':
            switch(note[1]){
                case '\0':
                    n += 8; if(fl[3]){n--;} if(sl[3]){n++;} break;
		case 'N':
		    n += 8; fl[3]=sl[3]=0; break;
                case '#':
                case 's':
		case 'S':
		    sl[3]=1;
                    n += 9; break;
                case 'b':
		case 'F':
                case 'f':
		    fl[3]=1;
                    n += 7; break;
                default:
                    m->pitch = 121; return PBSERROR;
            }
        break;
        case 'G':
            switch(note[1]){
                case '\0':
                    n +=10; if(fl[4]){n--;} if(sl[4]){n++;} break;
		case 'N':
		    n +=10; fl[4]=sl[4]=0; break;
                case '#':
                case 's':
		case 'S':
          	    sl[4]=1; n += 11; break;
                case 'b':
                case 'f':
		case 'F':
		    fl[4]=1;
                    n += 9; break;
                default:
                    m->pitch = 121; return PBSERROR;
            }
        break;
        case 'H':
            switch(note[1]){
                case '\0':
                    n += 2; if(fl[6]){n--;} if(sl[6]){n++;} break;
				case 'N':
					n += 2; fl[6]=sl[6]=0; break;
                case '#':
                case 's':
		case 'S':
					sl[6]=1;
                    n += 3; break;
                case 'b':
                case 'f':
		case 'F':
					fl[6]=1;
                    n += 1; break;
                default:
                    m->pitch = 121; return PBSERROR;
            }
        break;
        case 'R':
            switch(note[1]){
                case '\0':
                    n = 121; break;
                default:
                    m->pitch = 121; return PBSERROR;
            }
        break;
        default:
            m->pitch = 121; return PBSERROR;
    }
    m->pitch = n;
    if(debug_level)
    	cout << "pitch=" << n << endl;
    return PBSOK;
}

pbsconvert_result beats(PBSP * m){
if(debug_level>1)
	cout << "beats called... " << rnum << endl;
switch(rnum[0]){
    case '1':
        switch(rnum[1]){
        case '\0':
            m->length = 7; abeats += 1.0; break;
		case '.':
			m->length = 4; m->third = 1; abeats += 1.5; break;
        case '0':
            m->length = 2; m->third = 1; break;
        case '2':
            m->length = 1; m->third = 1; break;
        case '6':
            m->length = 0; abeats += 1.0/16.0; break;
        default:
            m->length = 3; return PBSERROR;
        }
        break;

    case '2':
        switch(rnum[1]){
        case '\0':
            m->length = 5; abeats += 1.0/2.0; break;
        case '.':
            m->length = 6; abeats += 3.0/4.0; break;
        default:
            m->length = 3; return PBSERROR;
        }
        break;

    case '3':
        switch(rnum[1]){
        case '\0':
            m->length = 7; m->third = 1; break;
		case '2':
			m->length = 0; m->third = 1; abeats += 1.0/32.0; break;
        default:
            m->length = 3; return PBSERROR;
        }
        break;

    case '4':
        switch(rnum[1]){
        case '\0':
            m->length = 3; abeats += 1.0/4.0; break;
        case '.':
            m->length = 4; abeats += 3.0/8.0; break;
        default:
            m->length = 3; return PBSERROR;
        }
        break;

    case '5':
        switch(rnum[1]){
        case '\0':
            m->length = 6; m->third = 1; break;
        default:
            m->length = 3; return PBSERROR;
        }
        break;

    case '6':
        switch(rnum[1]){
        case '\0':
            m->length = 5; m->third = 1; break;
        default:
            m->length = 3; return PBSERROR;
        }
        break;

    case '8':
        switch(rnum[1]){
        case '\0':
            m->length = 1; abeats += 1.0/8.0; break;
        case '.':
            m->length = 2; abeats += 3.0/16.0; break;
        default:
            m->length = 3; return PBSERROR;
        }
        break;

    case '9':
        switch(rnum[1]){
        case '\0':
            m->length = 3; m->third = 1; break;
        default:
            m->length = 3; return PBSERROR;
        }
        break;
    default:
        m->length = 3; return PBSERROR;
    }
    return PBSOK;
}

readtone_result readtone(PBSP * m){
    skipspace();
    int nnum  = 0;
    int nnote = 0;

    if(debug_level)
    	cout << "reading tone in line " << line << endl;
    while(1){
	if(debug_level>1)
        cout << "#" << buf[0] << flush;

        if(l!=1){
	    if(debug_level>1)
            	cout << endl << "shouldn't happen 1" << endl;
            m->end=1;
            return RTEOF;
        }

	if(buf[0]=='['){
		if(debug_level)
			cout << "Wiederholung... " << flush;
		while(l==1 && buf[0]!=']'){
			l=read(fd,buf,1);
			if(buf[0]=='\'') skipcomment();
			if(debug_level>1)
				cout << buf[0] << "-" << flush;
		}
		if(debug_level)
			cout << endl;
	}

        if((buf[0]==' ' || buf[0]=='^') && (nnote||nnum)){
            //cout << endl << "Leerstelle gefunden - Tonende" << endl;
		if(pitch(m)==PBSERROR)
			cout << "pitch error in line " << line << endl;
        	beats(m);
			l=1;
			while(!isNum(buf[0]) && !isNote(buf[0]) && buf[0]!=';' && buf[0]!='\\' && l==1){
				l = read(fd,buf,1);
				if(buf[0]=='\'') skipcomment();
			}
			if((isNum(buf[0]) || isNote(buf[0])) && !comment){
				lseek(fd,-1,SEEK_CUR);
				return RTOK;
			}
			if(buf[0]==';')
				return RTEOV;
			if(buf[0]=='\\')
				return RTEOT;
            return RTEOF;
        }
        if(buf[0]==';'){
            //cout << endl << "Semikolon gefunden - Stimmenende" << endl;
            if(pitch(m)==PBSERROR)
		cout << "pitch error in line " << line << endl;
            beats(m);
            return RTEOV;
        }
        if(buf[0]=='\\'){
            //cout << endl << "Backslash gefunden - Taktende" << endl;
	    if(debug_level>1)
		cout << nnote << " nnote - nnum " << nnum << endl;
            if(pitch(m)==PBSERROR)
		cout << "pitch error in line " << line << endl;
            beats(m);
            return RTEOT;
        }

        if(isNum(buf[0]) && !nnote){
            if(nnum>1){
	    	if(debug_level>1)
                    cout << "shouldn't happen 2" << endl;
            	return RTERROR;
            }
            rnum[nnum]=buf[0];
            if(!nnum){
                rnum[1]='\0';
	    }
            nnum++;
        }
        if(isNum(buf[0]) && nnote){
            if(nnum>3){
	    	if(debug_level>1)
                cout << "shouldn't happen 3" << endl;
                return RTERROR;
            }
            rokt[nnum]=buf[0];
	    rokt[1]='\0';
            nnum++;
        }
        if(isNote(buf[0])){
            if(nnote>1){
	    	if(debug_level>1)
                cout << "shouldn't happen 4" << endl;
			return RTERROR;
            }
            note[nnote]=buf[0];
            note[nnote+1]='\0';
            nnote++;
            nnum = 0;
        }
        l = read(fd,buf,1);
	if(buf[0]=='\'') skipcomment();
	if(buf[0]==':'){
            cout << endl << "Doppelpunkt gefunden - Wiederholung" << endl;
	    l = read(fd,buf,1);
	    // hier weiterarbeiten !!
	    if(buf[0]=='\\') // :}
              return RTEOV;
        }
    }
}

//================================================ MAIN ===================================================\\

int main(int argc, char * argv[]) {
    cout << "MusPlay version " << musplay_version << " is free software" << endl;
    if(argc < 2){
        cout << "syntax: " << argv[0] << " (options) [file]" << endl;
		cout << "options: \n"
		<< "\t-t [time]: playing lenght\n"
		<< "\t-V [volume %]: total volume\n"
		<< "\t-w [wav file]: wav output filename\n"
		<< "\t-b [bytes]: bytes per value (1 or 2)\n"
		<< "\t-f[n] [fms file]: fms format output for voice n\n"
		<< "\t-v[n] [volume %]: relative volume for voice n or global\n"
		<< "\t-h[n] [fms envelope file]: envelope for voice n or global\n"
		<< "\t-i[n] [fms instrument file]: instrument for voice n or global\n"
		<< "\t-p [frequency]: concert pitch"
		<< endl;
        return 0;
    }

	// herausfinden, wieviele Stimmen
    fd = open(argv[argc-1], O_RDONLY);
    if(fd < 1) {
        cout << "Error opening file" << endl;
        return 0;
    }

	cout << "converting mus file..." << endl;

    findtakt();   // Fehler hier werden dummerweise nicht erkannt

	if(debug_level){
	cout << "Vorzeichen:";
	for(int i=0; i<7; i++){
		if(f[i]) cout << " b" << i;
		if(s[i]) cout << " #" << i;
	}
	cout << endl;
	}

    countvoices();
    close(fd);

    PBSP  *recent[voices]    ; // aktuelle Wertkombination
    PBSP  *first[voices]     ; // Pointer auf Anfangswerte
    PBSP  *before[voices]    ; // Pointer auf vorherigen Wert

	double time = 20.0;
	double volume = 100.0;
	double freq = 441.0;
	char *wavname=0;
	int bytes = 2;
	bool quiet=0;
    char buf[1];

	int ntone[voices];
	double vvol[voices];
	char *dhvol=0, *dinst=0;
	char *hvol[voices];
	char *inst[voices];
	char *fmfile[voices];

    for(l=0; l<voices; l++)
    {
    	recent[l] = new PBSP;
    	first[l] = recent[l];
    	before[l] = 0;
    	ntone[l] = 0;
	vvol[l]=100.0;
	hvol[l]=0;
	inst[l]=fmfile[l]=0;
    }

	for(int i=1;i<argc-2;i++)
	{
		if(argv[i][0]=='-'){
		switch(argv[i][1]){
                  case 'q':
			quiet=1; i--; break;
		  case 'f':
			if(voices>=atoi(argv[i]+2)>0){fmfile[atoi(argv[i]+2)-1]=argv[i+1];} break;
		  case 't':
		  	time = atof(argv[i+1]); if(time<=0.0) time = 20.0; break;
		  case 'V':
			volume = atof(argv[i+1]); if(volume>100.0||volume<0.0) volume=100.0; break;
		  case 'v':
		  	if(voices>=atoi(argv[i]+2)>0){vvol[atoi(argv[i]+2)-1]=atof(argv[i+1]);
			if(vvol[atoi(argv[i]+2)-1]>100.0||vvol[atoi(argv[i]+2)-1]<0.0) vvol[atoi(argv[i]+2)-1]=100.0;} break;
		  case 'h':
			if(argv[i][2]=='\0')dhvol=argv[i+1];
		  	else if(voices>=atoi(argv[i]+2)>0){hvol[atoi(argv[i]+2)-1]=argv[i+1];}
			break;
		  case 'i':
			if(argv[i][2]=='\0'){dinst=argv[i+1]; if(debug_level) cout << "set default instrument: " << dinst << endl;}
		  	if(voices>=atoi(argv[i]+2)>0){inst[atoi(argv[i]+2)-1]=argv[i+1];}
			break;
		  case 'w':
		  	wavname = argv[i+1]; break;
		  case 'b':
		  	bytes = atoi(argv[i+1]); break;
		  case 'p':
		  	freq = atoi(argv[i+1]); break;
		}
		i++;
		}
	}


    fd = open(argv[argc-1], O_RDONLY);
    line = 1;
    if(fd < 1) {
        cout << "Error opening file" << endl;
        return 0;
    }

    findtakt();

    bool go = 1;
    int av=0; // aktuelle Stimme

	for(int i=0; i<7; i++){
		fl[i]=f[i];  // Vorzeichen neu laden
		sl[i]=s[i];
	}
	float tbeats = 1.5;
	abeats=0.0;
    while(go){
        //cout << endl << "new tone" << endl;
        ntone[av]++;
        switch(readtone(recent[av])){
            case RTOK:
		if(recent[av]->pitch==121 && note[0]!='R')
			cout << "\apitch error in line " << line << endl;
                recent[av]->next = new PBSP;
                recent[av] = recent[av]->next;
                break;
            case RTEOV:
		recent[av]->next = new PBSP;
                recent[av] = recent[av]->next;
                if(av==0)
		    tbeats=abeats;
		if(abeats!=tbeats)
			cout << "\arhythm wrong in line " << line << ": " << abeats << " beats!" << endl;
		abeats = 0.0;
		av = (av+1) % voices;

		for(int i=0; i<7; i++){
			fl[i]=f[i];  // Vorzeichen neu laden
			sl[i]=s[i];
		}
		break;
            case RTEOT:
		if(av==0)
		    tbeats=abeats;
		if(abeats!=tbeats)
		    cout << "\arhythm wrong in line " << line << ": " << abeats << " beats!" << endl;
		abeats = 0.0;

                recent[av]->next = new PBSP;
                recent[av] = recent[av]->next;
                if(findtakt()==GOTOEOF){
                    go = 0;
                    recent[av]->end = 1;
                }
		av = (av+1) % voices;
		if(debug_level>1)
			cout << "neue Stimme: " << av+1 << endl;
		for(int i=0; i<7; i++){
			fl[i]=f[i];  // Vorzeichen neu laden
			sl[i]=s[i];
		}
                break;
            case RTEOF:
                recent[av]->end = 1;
		ntone[av]--; //do we need this? - seems so!
                go = 0;
                break;
            case RTERROR:
                cout << "Can't go on, some kind of error occured. [line " << line << "]" << endl;
                return 0;
        }
    }
    FMPlayer p;
	p.setBytes(1+(bytes==2));
	p.package->setTime(time);
	p.package->setVolume(volume/100.0);
    // convert from pbsp to pbs
    PBS *d[voices];

    for(av=0; av<voices; av++)
    {
	    d[av] = new PBS[ntone[av]];
	    recent[av]=first[av];
	    for(int i=0; i<ntone[av]; i++)
	    {
		    d[av][i].beats=beats(recent[av]->length,recent[av]->third);
		    d[av][i].pitch=pitch(recent[av]->pitch-1);
		    d[av][i].style=0;
		    recent[av]=recent[av]->next;
	    }
		p.sound->setVolume(vvol[av]/100.0);
	    p.sound->setMode(2);
	    p.sound->setVlen(ntone[av]);
		if(debug_level)
			cout << "setVlen to " << ntone[av] << endl;
	    p.sound->pbs=d[av];
	    p.sound->setMidi();
		if(inst[av]){
			if(debug_level)
				cout << "individual filename: " << inst[av] << " " << av << endl;
			p.sound->midi->setMidiI(0,inst[av]);
		}
		else if(dinst)
			p.sound->midi->setMidiI(0,dinst);
		else{
			if(debug_level>1)
				cout << "default filename" << endl;
			p.sound->midi->setMidiI(0,DATADIR "sounds/tri");
		}

		if(hvol[av])
			p.sound->midi->setMidiH(0,hvol[av]);
		else if(dhvol){
			if(debug_level) cout << "set hvol " << av << " to " << dhvol << endl;
			p.sound->midi->setMidiH(0,dhvol);
		}
	    p.sound->midi->initMidi();
		p.sound->setFreq(freq);
	    if(av<voices-1){
	    	p.sound->next = new FMSoundfile(p.package);
			p.sound = p.sound->next;
	    }
	    if(fmfile[av]){
		cout << "writing voice " << av+1 << " to file..." << endl;
		int fmfd=fmopen(fmfile[av]);
		cout << "." << endl;
		mode(2,fmfd);
		cout << "." << endl;
		name("Musfile",7,fmfd);
		cout << "." << endl;
		values(ntone[av],fmfd,first[av]);
		cout << "." << endl;
		cleanup(fd);
	}
    }
	cout << quiet << endl;
      if(wavname || !quiet){
	if(wavname)
		p.setWavFile(wavname);
	cout << "computing... [please be patient, and I mean it]" << endl;

	p.compute();
        p.playInit();
	l=0;
	char prog[60] = "|                                                   |   0%";
	int perc = int(time*p.getRate()/100.0);
	cout << "playing " << voices << " voices..." << endl;
        while(p.first->ptr){
	    p.playVal();
		l++;
		if(l%perc==0){
			if(int(l/perc)%2==0)
				prog[int(l/perc*0.5)+1]='-';
			else
				prog[int(l/perc*0.5)+1]='=';
			prog[56] = int(l/perc)%10+48;
			prog[55] = int((int(l/perc)-int(l/perc)%10)/10)+48;
			if(l/perc<10)
				prog[55]=' ';

			cout << prog << "\r" << flush;
		}
	}
	prog[55]=prog[56]='9';
	cout << prog << "\r" << flush;
	p.playCleanup();

	prog[51]='='; prog[54]='1'; prog[55]='0'; prog[56]='0';
	cout << prog << endl;
      }
	if(debug_level){
		cout << "beats per minute: ";
		p.package->firstSound();
		for(av=0; av<voices; av++){
			cout << p.package->sound->midi->getBps() << " ";
			p.package->nextSound();
		}
		cout << endl;
	}
    close(fd);
}

