unit Unit1;

interface

//uses    // Linux - bei Windows auskommentieren
//  SysUtils, Types, Classes, Variants, QTypes, QGraphics, QControls, QForms,
//  QDialogs, QStdCtrls;

uses    // Windows - bei Linux auskommentieren
  Windows, Messages, SysUtils, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Button1: TButton;
    procedure FormCreate (Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Button1Click(Sender: TObject);  private
    { Private declarations }
  public
    { Public declarations }
  end;

type PCoordRecord=^TCoordRecord;
 TCoordRecord=record
 cx, cy: Integer;
end;

type SpeicherListe=class(TList)
end;

var
  Form1: TForm1;
  Liste: TList;
  Coord: ^TCoordRecord;
  N: Integer;

implementation

{$R *.dfm}

procedure TForm1.FormCreate (Sender: TObject);
begin
Liste:=SpeicherListe.create;
n:=0;
end;

procedure TForm1.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  canvas.Brush.Color:=200;
  canvas.Ellipse(x-3,y-3,x+3,y+3);
  new(Coord);
  Coord.cx:=x;
  Coord.cy:=y;
  Liste.add(Coord);
  inc(n);
  Label1.Caption:=inttostr(n);

end;

procedure TForm1.Button1Click(Sender: TObject);
var grade,i,j,m,d: integer;
    Coord2: ^TCoordRecord;
var r,s,t,e: real;
    k: array[0..20] of real;
begin

// clear screen
Canvas.Brush.Color:=clScrollBar;
Canvas.FillRect(ClientRect);
     grade:=n-1;
     if (grade<1) then
     begin
        Label1.Caption:='first click somewhere';
        exit;
     end;
     if (grade>19) then
     begin
        Label1.Caption:='too many points';
        exit;
     end;
// check for double values
for i:=0 to grade do
begin
   Coord:=Liste.Items[i];
   for j:=0 to grade do
   begin
      Coord2:=Liste.Items[j];
      if Coord.cx=Coord2.cx then
      if j<>i then
      begin
        Label1.Caption:='redundant points';
        exit;
      end;
   end;
end;

for i:=0 to grade do
begin
// find k[0...grade], which is A,B,C,...
// k[0] is y1
// k[1] is (y2-y1)/(x2-x1)
// ...
// f(x)=A+B(x-x1)+C(x-x1)(x-x2)+...
        Coord:=Liste.Items[i];

        canvas.Brush.Color:=200;
        canvas.Ellipse(Coord.cx-3,Coord.cy-3,Coord.cx+3,Coord.cy+3);

        r:=Coord.cy; // r - our k[i] nominator
        s:=1; // s - our k[i] denominator
        for j:=0 to i-1 do
        begin
            t:=1; // t: Faktoren aus Differenzen in Klammern, (x-x1)*(x-x2)...
            for m:=0 to j-1 do
            begin
               Coord2:=Liste.Items[m];
               t:=t*(Coord.cx-Coord2.cx);
            end;
            Coord2:=Liste.Items[j];
            r:=r-k[j]*t;
            s:=s*(Coord.cx-Coord2.cx);
        end;
        k[i]:=r/s;
end;

for d:=0 to Form1.Width do // d is the x coord.
begin
  e:=0; // e is the y coord.
  for i:=0 to grade do
  // add i-th part
  begin
     t:=k[i];  // temporary i-th part
     for j:=0 to i-1 do
     begin
         Coord2:=Liste.Items[j];
	 	// multiply with (x-xj)
		t:=t*(d-Coord2.cx);
     end;
     e:=e+t;
  end;
  if d>0 then
        canvas.LineTo(round(d),round(e));
        canvas.MoveTo(round(d),round(e));
end;


end;

end.
