/**************************************************************************
        pasport.cpp - zum Portieren von PASCAL-Programmen mit Grafik
                             -------------------
    begin                : April 10th 2002
    copyright            : (C) 2002 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
#include "pasport.h"

#include <iostream>

using namespace std;

Uint32 FILLCOLOR = C15;
Uint32 NORMCOLOR = C15;
int  SETX = 320;
int  SETY = 240;
int  TEXX = 0;
int  TEXY = 0;
int  MAXX = 0;
int  MAXY = 0;
bool writetogfx = 0;

SDL_Surface *screen;

int fluchtx = 10;
int fluchty = 320;

float ARCTAN(float x){ return atan(x);}

void BAR(int x1, int y1, int x2, int y2, bool u){
	boxColor(screen, x1, y1, x2, y2, FILLCOLOR);
	if(u)
		SDL_UpdateRect(screen,0,0,0,0);
}

char CHR(int c){
	return char(c);
}

void CIRCLE(int x, int y, int r, bool u){
	circleColor(screen, x, y, r, NORMCOLOR);
	if(u)
		SDL_UpdateRect(screen,0,0,0,0);
}

void CLOSEGRAPH(){
	SDL_Quit();
	MAXX=0; MAXY=0;
}

void CLRSCR(){
	cout << "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n" << endl;
}

float COS(float x){ return cos(x);}

void DELAY(int ms){
	SDL_Delay(ms);
}

void ELLIPSE(int x, int y, int rx, int ry, bool u){
	ellipseColor(screen, x, y, rx, ry, NORMCOLOR);
	if(u)
		SDL_UpdateRect(screen,0,0,0,0);
}

double EXP(double x){
	return pow(E,x);
}

void FILLELLIPSE(int x, int y, int rx, int ry, bool u){
	filledEllipseColor(screen, x, y, rx, ry, FILLCOLOR);
	ELLIPSE(x, y, rx, ry, 0);
	if(u)
		SDL_UpdateRect(screen,0,0,0,0);
}

void GOTOXY(int x, int y, bool gfx){
	while(x>=80){
		x-=80;
		y+=1;
	}
	y%=25;
	if(gfx){
		writetogfx=1;
		if(!MAXX*MAXY)
			INITGRAPH();
		MOVETO(x*MAXX/81, y*MAXY/26);
	}
	TEXX=x; TEXY=y;
}

void INITGRAPH(int x, int y){
	SDL_Init(SDL_INIT_VIDEO);	//das Video-Modul initialisieren
	SDL_Init(SDL_INIT_TIMER);	//das Timer-Modul initialisieren

	screen = SDL_SetVideoMode(x, y,
		 8, SDL_SWSURFACE | SDL_ANYFORMAT);
		 
	MAXX=x;
	MAXY=y;
}

bool KEYPRESSED(){
	SDL_Event event;

	if(SDL_PollEvent(&event))
        {
        switch (event.type)
            {
	    case SDL_KEYDOWN:
				return 1;
			default:
				return 0;
						}
        }

	return 0;
}

void LINE(int x1, int y1, int x2, int y2, bool u){
	lineColor(screen, x1, y1, x2, y2, NORMCOLOR);
	if(u)
		SDL_UpdateRect(screen,0,0,0,0);
}

void MOVETO(int x, int y){
	SETX = x; SETY = y;
}

void NOSOUND(){
	cout << "NOSOUND() is not implemented yet" << endl;
}

void OUTTEXT(char * text, bool u){
	OUTTEXTXY(SETX,SETY,text);
	if(u)
		SDL_UpdateRect(screen,0,0,0,0);
}

void OUTTEXTXY(int x, int y, char * text, bool u){
	stringColor(screen, x, y, text, NORMCOLOR);
	if(u)
		SDL_UpdateRect(screen,0,0,0,0);
}

void OUTTEXTXY(int x, int y, char text, bool u){
	char a[1];
	a[0] = text;
	stringColor(screen, x, y, a, NORMCOLOR);
	if(u)
		SDL_UpdateRect(screen,0,0,0,0);
}

void PIESLICE(int x, int y, int sa, int ea, int r, bool u){
	filledpieColor(screen, x, y, r, sa, ea, FILLCOLOR);
	if(u)
		SDL_UpdateRect(screen,0,0,0,0);
}

void PUTPIXEL(int x, int y, int color, bool u){
	pixelColor(screen, x, y, translateColor(color));
	if(u)
		SDL_UpdateRect(screen,0,0,0,0);
}

int RANDOM(int MAX){
	int x;
	if(MAX)
		x = rand()%MAX;
	else
		x = 0;
	return x;
}

void RANDOMIZE(){
	srand(time((time_t *)NULL));
}

void READ(int * r){
	READLN(r);
}

void READ(char * r){
	READLN(r);
}

char READKEY(){

	cout << "warning: READKEY() is not completely compatible" << endl;

	SDL_Event event;

	while (SDL_WaitEvent(&event) >= 0)
        {
        switch (event.type)
            {
	    case SDL_KEYDOWN: {
			switch (event.key.keysym.sym) {
				case SDLK_ESCAPE:
					return 27;
				case SDLK_UP:
					return 72;
				case SDLK_DOWN:
					return 80;
				case SDLK_RIGHT:
					return 77;
				case SDLK_LEFT:
					return 75;
				default:
					return 0;
			}
	    }
        }
    }
	return 0; //should never be reached
}

void READLN(){
	SDL_Event event;
  while (SDL_WaitEvent(&event) >= 0)
    {
    switch (event.type)
        {
        case SDL_KEYDOWN:
          {
          return;
          }
        }
    }
}

void READLN(int * r){
	int n;
	cin >> n;
	*r = n;
}

void READLN(char * r){
	char n;
	cin >> n;
	*r = n;
}

void READLN(float * r){
	float n;
	cin >> n;
	*r = n;
}

int ROUND(float x){
	return (float(x-int(x))>=0.5) ? int(x+1.0) : int(x);
}

void SETFILLSTYLE(int STYLE, int COLOR){
	COLOR = COLOR % 16;
	FILLCOLOR = translateColor(COLOR);
}

void SETCOLOR(int COLOR){
	COLOR = COLOR % 16;
	NORMCOLOR = translateColor(COLOR);
}

float SIN(float x){ return sin(x);}

void SOUND(int freq){
	cout << "SOUND(int) is not implemented yet" << endl;
}

float SQR(float x) {return x * x;}

float SQRT(float x){ return sqrt(x);}

int TRUNC(float x){ return int(x);}

char UPCASE(char r){
	if(123>r>97)
		return r-32;
	return r;
}

void WRITE(char * r){
	if(writetogfx){
		OUTTEXTXY(SETX,SETY,r);
		GOTOXY(SETX+strlen(r),SETY);
	}
	else
		cout << r << flush;
}

void WRITE(float r){
	if(writetogfx){
		cerr << "\acan't write float to graphic" << endl;
	}
	else
		cout << r << flush;
}

void WRITELN(char * r){
	if(writetogfx){
		OUTTEXTXY(SETX,SETY,r);
		GOTOXY(0,TEXY+1);
	}
	else
		cout << r << endl;
}

void WRITELN(char r){
	if(writetogfx){
		OUTTEXTXY(SETX,SETY,r);
		GOTOXY(0,TEXY+1);
	}
	else
		cout << r << endl;
}

void WRITELN(int r){
	if(writetogfx){
		cerr << "\acan't write int to graphic" << endl;
	}
	else
		cout << r << endl;
}

void WRITELN(float r){
	if(writetogfx){
		cerr << "\acan't write float to graphic" << endl;
	}
	else
		cout << r << endl;
}

/*-------------------------------------------------------*/

void UPDATE(){
	SDL_UpdateRect(screen,0,0,0,0);
}

Uint32 translateColor(int nr){
nr = nr % 16;
 switch(nr){
	case 0:
		return C0;
	case 1:
		return C1;
	case 2:
		return C2;
	case 3:
		return C3;
	case 4:
		return C4;
	case 5:
		return C5;
	case 6:
		return C6;
	case 7:
		return C7;
	case 8:
		return C8;
	case 9:
		return C9;
	case 10:
		return C10;
	case 11:
		return C11;
	case 12:
		return C12;
	case 13:
		return C13;
	case 14:
		return C14;
	case 15:
		return C15;
 }
 return 0;
}

/*-------------------------------------------------------*/
/* 3d functions */


ddcoord xycoord(dddcoord a) {
	ddcoord tmp;
	tmp.x = int(a.x) % MAXX + (MAXX - int(a.x) % MAXX) * (1.0-(1.0/(a.z/100.0+1.0)));
	tmp.y = int(a.y) % MAXY + (MAXY - int(a.y) % MAXY) * (1.0-(1.0/(a.z/100.0+1.0)));
	return tmp;
}

void dddpunkt(dddcoord a, int color, bool ppp, bool con, bool u) {

	if(ppp){
		pixelColor(screen, int(a.x) % MAXX, int(a.y) % MAXY, 0xFF3A3AFF);
		if(u && !con)
			SDL_UpdateRect(screen, int(a.x) % MAXX, int(a.y) % MAXY, 1, 1);
	}
	ddcoord b = xycoord(a);
	pixelColor(screen, int(b.x), int(b.y), translateColor(color));
	if(u && !con)
		SDL_UpdateRect(screen, int(b.x), int(b.y), 1, 1);
	if(con){
		lineColor(screen, int(b.x), int(b.y), int(a.x) % MAXX, int(a.y) % MAXY, 0x7b007bb0);
		if(u)
			SDL_UpdateRect(screen, 0, 0, 0, 0);
	}
}

