#!/bin/sh
# starte Tcl-Interpeter \
exec tclsh $0 "$@"

puts "Dateiname: "
set pasname [gets stdin]
set cppname $pasname

append pasname ".pas"
append cppname ".cpp"

set f [open $pasname r]

set pascode [read -nonewline $f]
close $f

set f [open $cppname w]

# pascode enthlt jetzt die ganze PAS-Datei

# anstatt der PROGRAM-Zeile braucht die cpp-Datei
# eine #include "pasport.h" - Zeile
regsub {PROGRAM([A-Z]|[0-9]| )*;} $pascode {#include "pasport.h"} pascode

# da die USES auch keine Bedeutung haben, wird
# hier ein Copyright-Verweis eingefgt
regsub -nocase {USES([A-Z]|,| )*;} $pascode "// This has just become free software\n// licensed under the Gnu GPL.\n// See www.gnu.org/copyleft/gpl.html\n// for details." pascode

# die folgenden Zeilen muss noch verfeinert werden,
# um verschiedene Variablentypen zu untersttzen
set offset 0
if {[regexp -nocase {INTEGER} $pascode]} {
	set offset [string first {INTEGER} $pascode $offset]
	if {[expr [regexp -nocase {;} $pascode] < [regexp -nocase {VAR} $pascode] < $offset]} {
		# wenn ; vor einem VAR vor INTEGER kommt
		regsub -nocase {VAR} $pascode {int} pascode
		regsub -nocase {( )*:( )*INTEGER;} $pascode {;} pascode
	}
}

set offset 0
if {[regexp -nocase {CHAR} $pascode]} {
	set offset [string first {CHAR} $pascode $offset]
	if {[expr [regexp -nocase {;} $pascode] < $offset]} {
		# wenn ; vor CHAR kommt
		set offset [string first {;} $pascode]
		regsub -nocase {;} $pascode ";\nchar " pascode
		regsub -nocase {( )*:( )*CHAR;} $pascode {;} pascode
	}
}

regsub {VAR( )*} $pascode {int } pascode
regsub {:( )*Integer;} $pascode {;} pascode

# Kommentare, auch ber mehrere Zeilen
regsub -all "{" $pascode "/*" pascode
regsub -all "}" $pascode "*/" pascode

# Im Folgenden werden die BEGINs und ENDs
# durch geschweifte Klammern bzw. main()
# ersetzt. BEGIN und END innerhalb von
# PROCEDURES drften nicht funktionieren
set offset 0
while {[expr $offset >= 0]} {
set offset [string first {BEGIN} $pascode $offset]
regsub -start $offset {BEGIN} $pascode "\{" pascode
set offset [string first {PROCEDURE} $pascode $offset]
}
regsub {BEGIN} $pascode "main() {" pascode
regsub -all {BEGIN} $pascode "{" pascode
regsub -all {END(.|;)} $pascode "}" pascode

# aus PROCEDURES werden void-Funktionen
regsub -all "PROCEDURE" $pascode "void" pascode

# aus allen := werden vorlufig = gemacht
regsub -all {:=} $pascode {=} pascode

# ein eventuelles DRV:=DETECT wird gelscht
regsub -all -nocase -line "(\n)+(.)*(A-Z)*=DETECT;" $pascode "" pascode

# INITGRAPH() in pasport.h ist ohne Parameter
regsub -all -nocase -line {INITGRAPH(.)*;} $pascode {INITGRAPH();} pascode

# REPEAT-UNTIL-Schleifen
regsub -all {REPEAT} $pascode "do {" pascode
# geschlossene Klammer muss dahinter!
set offset 0
while {[expr $offset >= 0]} {
	set offset [string first {UNTIL } $pascode $offset]
	regsub -start $offset {UNTIL } $pascode "\} while\(!" pascode
	set offset [string first {!} $pascode $offset]
	regsub -start $offset {\);} $pascode "\)\);" pascode
	set offset [string first {UNTIL } $pascode $offset]
}

#funktioniert noch nicht, soll alle FOO; durch FOO(); ersetzen

set offset [string first "\{" $pascode]
set offset [string first ";" $pascode $offset]
while {[expr $offset >= 0]} {
	puts [string index $pascode [expr $offset - 1]]
	if {[regexp -nocase {(A-Z)+} [string index $pascode [expr $offset - 1]]]} {
		# wenn das Zeichen vor dem ; ein Buchstabe ist
		regsub -line -start $offset {\;} $pascode "();" pascode
		puts FFF
	}
	set offset [expr $offset + 1]
	set offset [string first {;} $pascode $offset]
	puts $offset
}

regsub -all {READLN;} $pascode {READLN();} pascode
regsub -all {CLOSEGRAPH;} $pascode {CLOSEGRAPH();} pascode
regsub -all { MOD } $pascode { % } pascode
# FOR ... TO ... DO - Schleifen
# verfeinern:  ersetzen
regsub -all {FOR } $pascode {for(} pascode
regsub -all { TO } $pascode {; <=} pascode
regsub -all { TO } $pascode {; >=} pascode
regsub -all { DO}  $pascode {; ++)} pascode

puts "Output:"
puts $pascode

puts -nonewline $f $pascode

close $f

exit


