// This is Free Software
// See the GNU General Public License @ http://www.gnu.org/copyleft/gpl.html
// for details about the terms and conditions for using and distributing
// this piece of software.
// This software comes with absolutely NO WARRANTY!
// (c) 2005 by Daniel Gruen <daniel_gruen@web.de>

#ifndef _QGOODVIBES_
#define _QGOODVIBES_

#include <qwidget.h>
#include <qvbox.h>
#include <qcanvas.h>

#include <iostream>
using namespace std;

const double pi = 3.14159265359;
const double pi180 = pi/180.0;

struct dddcoord {
   double x;
   double y;
   double z;
};

struct ddcoord {
   float x;
   float y;
};

class GVCoupling;

class GVNode : public QObject, QCanvasEllipse {
	Q_OBJECT

	public:
		GVNode();
		void setCoupling(GVNode *c,double k); 
		// couple with c, spring constant K
		// couples partner as well!
		void addCoupling(GVCoupling *c); // adds coupling to list of c.s

		dddcoord position; // position
		dddcoord velocity; // velocity
		double mass;
		GVCoupling *firstC;

	public slots:
		void animate(); // sets new position and velocities
};

class QGoodVibes : public QCanvasView {
	Q_OBJECT

    public:
	QGoodVibes(QWidget *parent=0, const char *name = 0);

    private:
	int    msx,msy;
	GVNode *block[10][10][10]; // 3d array of Nodes

    public slots:
	void  setXAngle(int degrees);
	void  setYAngle(int degrees);
	void  debug_update() {/*cout << "." << flush;*/}
	
    signals:
	void  xAngleChanged(int);
	void  yAngleChanged(int);

    protected:
	void keyPressEvent(QKeyEvent * e);
	void mousePressEvent(QMouseEvent * e);
	void mouseMoveEvent(QMouseEvent * e);
};


class GVCoupling {
    public:
        GVCoupling() {k=1; d=10; n=0; next=0;}
	double k; // spring constant
	double d; // default distance
	GVNode *n; // connected node
    	void setNextC(GVCoupling *dnext) {next=dnext;}
	GVCoupling *nextC() {return next;}
    private:
	GVCoupling *next;
};

#endif
