// this is free software
// see file "COPYING for details

#include "simulator.h"
#include "dim.h"

#include <qcanvas.h>
#include <qstring.h>
#include <qbrush.h>
#include <qcolor.h>
#include <qbutton.h>

#include <cstdlib>
#include <ctime>
#include <iostream>
#include <cmath>


Particle::Particle( QCanvas *canvas, Universe *du, int i, double m )
	: QCanvasEllipse(int(pow(10.0,1.0/3.0*log10(m*200.0/(4.0/3.0*PI))))+1,int(pow(10,1.0/3.0*log10((m*200.0/(4.0/3.0*PI)))))+1,canvas) {
	u = du;
	c = canvas;
	setX(rand()%canvas->width());
        setY(rand()%canvas->height());
	setBrush(QBrush(QColor(rand()%80+175,rand()%80+155,rand()%100)));
	mass = m;
	setXVelocity(((rand()%30)/15.0-1.0));
	setYVelocity(((rand()%30)/30.0-0.5));
	if(i>0)
	 next = new Particle(canvas, du, i-1,double(rand()%8+1) / 10.0);
	else
	 next = 0;
	show();
}

void Particle::update(){
Particle * tmp = u->first;
while(tmp){
	if(tmp!=this){
	if(collidesWith(tmp)){
		QBrush b1 = tmp->brush();
		QBrush b2 = brush();
		QColor c1 = b1.color();
		QColor c2 = b2.color();
		tmp->setBrush(QBrush(QColor(int((c1.red()*tmp->mass+c2.red()*mass)/(tmp->mass+mass)), 
					    int((c1.green()*tmp->mass+c2.green()*mass)/(tmp->mass+mass)),
					    int((c1.blue()*tmp->mass+c2.blue()*mass)/(tmp->mass+mass)))));
		tmp->setXVelocity((tmp->xVelocity()*tmp->mass+xVelocity()*mass)/(tmp->mass+mass));
		tmp->setYVelocity((tmp->yVelocity()*tmp->mass+yVelocity()*mass)/(tmp->mass+mass));
		tmp->mass = tmp->mass + mass;
		tmp->setSize(int(pow(10,1.0/3.0*log10((200*tmp->mass/(4.0/3.0*PI)))))+1, int(pow(10,1.0/3.0*log10((200*tmp->mass/(4.0/3.0*PI)))))+1);
		tmp->setX((tmp->x()*tmp->mass+x()*mass)/(tmp->mass+mass));
		tmp->setY((tmp->y()*tmp->mass+y()*mass)/(tmp->mass+mass));
		Particle * before = u->first;
		while(before->next!=this && before->next)
			before = before->next;
		if(u->first == this)
			u->first = next;
		else
			before->next = next;
		delete this;
		return;
	}
	double dx = (tmp->x()-x());
	double dy = (tmp->y()-y());
	double xVel = xVelocity();
	double yVel = yVelocity();
	double dVel = (u->newton*(mass * tmp->mass) / (pow(dx,2.0)+pow(dy,2.0))) / mass; 
	// F = a * m; F = G*(m*m')/r
	// a*m = G*(m*m')/r
	// a = (G*(m*m')/r)/m
	double dYVel = dVel / sqrt(1+pow(dx/dy,2));
	double dXVel = dVel / sqrt(1+pow(dy/dx,2));
	if(dx<0)
	  setXVelocity(xVel-dXVel);
	if(dx>0)
	  setXVelocity(xVel+dXVel);
	if(dy<0)
	  setYVelocity(yVel-dYVel);
	if(dy>0)
	  setYVelocity(yVel+dYVel);
	}
	tmp=tmp->next;
}
if(u->bounce){
if(x()>X_DIM||x()<0){
	setXVelocity(-xVelocity()*0.95);
	if(x()>X_DIM)
		setX(X_DIM-1);
	else
		setX(1);
}
if(y()>Y_DIM||y()<0){
	setYVelocity(-yVelocity()*0.95);
	if(y()>Y_DIM)
		setY(Y_DIM-1);
	else
		setY(1);
}
}

if(next)
	next->update();
}


Universe::Universe( QCanvas *canvas ) : QObject(canvas)
{
	c = canvas;
	c->setBackgroundColor(QColor(0,0,0));
	srand(time((time_t *)NULL));
	bounce = 0;
	centered = 1;
	newton = 1.75;
	first = new Particle(c,this,29,100.0);
	update();		
	c->update();
}

void Universe::update(){
	first->update();
    if(centered){	
	Particle * tmp = first;
	Particle * heaviest = first;
	while(tmp){
		if(tmp->mass > heaviest->mass)
			heaviest = tmp;
		tmp = tmp->next;
	}
	
	tmp = first;
	while(tmp){
		tmp->setX(tmp->x()-heaviest->x()+X_DIM/2.0);
		tmp->setY(tmp->y()-heaviest->y()+Y_DIM/2.0);
		tmp = tmp->next;
	}
    }
}

void Universe::setBounce(int b){
	if(b == QButton::Off)
		bounce=0;
	if(b == QButton::On)
		bounce=1;
}

void Universe::setNewton(int n){
	newton = float(n)/20.0;
}

void Universe::setCentered(int b){
	if(b == QButton::Off)
		centered=0;
	if(b == QButton::On)
		centered=1;
}

void Universe::addParticle(){
	Particle * tmp = first;
	while(tmp->next)
		tmp = tmp->next;
	tmp->next = new Particle(c,this,0,double(rand()%8+1)/10);
}

