// this is free software
// see file "COPYING" for details

#ifndef _WEB_
#define _WEB_

#include <qcanvas.h>

class Universe;

class Particle : public QCanvasEllipse
{
public:
    Particle ( QCanvas *canvas, Universe *du, int, double);
    void update();
    float mass;
    Particle * next;
    
private:
    QCanvas * c;
    Universe * u;
};


class Universe : public QObject  
{
	Q_OBJECT
public:
    Universe ( QCanvas *canvas );
    Particle *first;
    float newton;
    bool  bounce;

public slots:
    void update();
    void setNewton(int);
    void setBounce(int);
    void setCentered(int);
    void addParticle();

private:
    QCanvas *c;
    bool centered;
};

#endif 

