// this is free software
// see file "COPYING" for details

#include "simulatorwidget.h"
#include "simulatorview.h"
#include "simulator.h"
#include "dim.h"

#include <qcanvas.h>
#include <qlayout.h>
#include <qtimer.h>
#include <qhbox.h>
#include <qslider.h>
#include <qcheckbox.h>
#include <qpushbutton.h>

#define text_spacing 15

SimulatorWidget::SimulatorWidget( QWidget *parent, const char *name )
    : QWidget( parent, name )
{
    // Create and setup canvas and view
    c = new QCanvas( this, "Canvas" );
    c->setBackgroundColor( Qt::white );
    c->setAdvancePeriod( 10 );
    c->resize( X_DIM, Y_DIM );
    v = new SimulatorView( c, this, "CanvasView" );
    
    // Toolbar
    QHBox * tbox = new QHBox(this);
    QSlider * n = new QSlider(1,100,10,35,Qt::Horizontal,tbox);
    n->setFixedWidth(100);
    QCheckBox * b = new QCheckBox("Abprallen",tbox);
    QCheckBox * z = new QCheckBox("Zentriert",tbox);
    z->setChecked(1);
    QPushButton * a = new QPushButton("Mehr",tbox);
    
    QVBoxLayout * g = new QVBoxLayout(this);
    g->addWidget(tbox);
    g->addWidget(v);
        
    Universe * l;
    l = new Universe(c);
    QTimer *  timer = new QTimer(this);
    timer->changeInterval(10);
    connect(timer, SIGNAL(timeout()), l, SLOT(update()));
    connect(n, SIGNAL(valueChanged(int)), l, SLOT(setNewton(int)));
    connect(b, SIGNAL(stateChanged(int)), l, SLOT(setBounce(int)));
    connect(z, SIGNAL(stateChanged(int)), l, SLOT(setCentered(int)));
    connect(a, SIGNAL(clicked()), l, SLOT(addParticle()));
}

